/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.i18n;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.preferences.ApplicationResourcesFinderFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class RegexLocale
implements Locale {
    private static final Logger log = Logger.getLogger(RegexLocale.class);
    private final Map<Key, String> cache = Collections.synchronizedMap(new LRUMap(1000));
    private final Local resources;
    private String locale = java.util.Locale.getDefault().getLanguage();
    private final Pattern pattern = Pattern.compile("\"(.*)\"\\s*=\\s*\"(.*)\";");

    public RegexLocale() {
        this(ApplicationResourcesFinderFactory.get().find());
    }

    public RegexLocale(Local resources) {
        this.resources = resources;
    }

    @Override
    public void setDefault(String language) {
        this.locale = language;
        this.cache.clear();
    }

    @Override
    public String localize(String key, String table) {
        Key lookup = new Key(table, key);
        if (!this.cache.containsKey(lookup)) {
            try {
                this.load(table);
            }
            catch (IOException e) {
                log.warn((Object)String.format("Failure loading properties from %s.strings. %s", table, e.getMessage()));
            }
        }
        if (this.cache.containsKey(lookup)) {
            return this.cache.get(lookup);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String table) throws IOException {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(String.format("%s/%s.lproj/%s.strings", this.resources.getAbsolute(), this.locale, table)), Charset.forName("UTF-16")));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = this.pattern.matcher(line);
                if (!matcher.matches()) continue;
                this.cache.put(new Key(table, matcher.group(1)), matcher.group(2));
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    private final class Key {
        private final String table;
        private final String key;

        public Key(String table, String key) {
            this.table = table;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key1 = (Key)o;
            if (this.key != null ? !this.key.equals(key1.key) : key1.key != null) {
                return false;
            }
            return !(this.table != null ? !this.table.equals(key1.table) : key1.table != null);
        }

        public int hashCode() {
            int result = this.table != null ? this.table.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }
    }
}

