/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import org.apache.commons.io.IOUtils;

public class CRC32ChecksumCompute
implements ChecksumCompute {
    @Override
    public Checksum compute(InputStream in, TransferStatus status) throws ChecksumException {
        CRC32 crc32 = new CRC32();
        try {
            int bytesRead;
            byte[] buffer = new byte[16384];
            while ((bytesRead = in.read(buffer, 0, buffer.length)) != -1) {
                crc32.update(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new ChecksumException(LocaleFactory.localizedString("Checksum failure", "Error"), e.getMessage(), e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return new Checksum(HashAlgorithm.crc32, Long.toHexString(crc32.getValue()));
    }
}

