/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.io.CRC32ChecksumCompute;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.MD5ChecksumCompute;
import ch.cyberduck.core.io.SHA1ChecksumCompute;
import ch.cyberduck.core.io.SHA256ChecksumCompute;
import ch.cyberduck.core.io.SHA512ChecksumCompute;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;

public final class ChecksumComputeFactory {
    private ChecksumComputeFactory() {
    }

    public static ChecksumCompute get(HashAlgorithm algorithm) {
        switch (algorithm) {
            case md5: {
                return new MD5ChecksumCompute();
            }
            case sha1: {
                return new SHA1ChecksumCompute();
            }
            case sha256: {
                return new SHA256ChecksumCompute();
            }
            case sha512: {
                return new SHA512ChecksumCompute();
            }
            case crc32: {
                return new CRC32ChecksumCompute();
            }
        }
        return new ChecksumCompute(){

            @Override
            public Checksum compute(InputStream in, TransferStatus status) throws ChecksumException {
                return Checksum.NONE;
            }
        };
    }
}

