/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ThresholdingOutputStream;

public class SegmentingOutputStream
extends ThresholdingOutputStream {
    private final ByteArrayOutputStream buffer;
    private final OutputStream proxy;

    public SegmentingOutputStream(OutputStream proxy, int threshold) {
        super(threshold);
        this.buffer = new ByteArrayOutputStream(threshold);
        this.proxy = proxy;
    }

    protected OutputStream getStream() throws IOException {
        return this.buffer;
    }

    protected void checkThreshold(int count) throws IOException {
        if (this.getByteCount() >= (long)this.getThreshold()) {
            this.copy();
        }
    }

    protected void thresholdReached() throws IOException {
    }

    public void close() throws IOException {
        if (this.getByteCount() > 0L) {
            this.copy();
        }
        this.proxy.close();
    }

    private void copy() throws IOException {
        this.buffer.writeTo(this.proxy);
        this.buffer.reset();
        this.resetByteCount();
    }
}

