/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.local.features.Touch;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class DefaultLocalTouchFeature
implements Touch {
    private static final Logger log = Logger.getLogger(DefaultLocalTouchFeature.class);

    @Override
    public void touch(Local file) throws AccessDeniedException {
        Local parent = file.getParent();
        if (!parent.exists()) {
            parent.mkdir();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Created folder %s", parent));
            }
        }
        if (file.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Skip creating file %s", file));
            }
            return;
        }
        try {
            Files.createFile(Paths.get(file.getAbsolute(), new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new LocalAccessDeniedException(MessageFormat.format(LocaleFactory.localizedString("Cannot create {0}", "Error"), file.getAbsolute()), e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Created file %s", file));
        }
    }
}

