/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.core.DefaultPathPredicate;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.local.TemporaryFileService;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;

public class DefaultTemporaryFileService
implements TemporaryFileService {
    private static final Logger log = Logger.getLogger(DefaultTemporaryFileService.class);
    private static final Set<Local> files = new LinkedHashSet<Local>();
    private final String delimiter = PreferencesFactory.get().getProperty("local.delimiter");

    @Override
    public Local create(Path file) {
        return this.create(new UUIDRandomStringService().random(), file);
    }

    @Override
    public Local create(String name) {
        return this.create(new UUIDRandomStringService().random(), name);
    }

    @Override
    public Local create(String uid, Path file) {
        String pathFormat = "%2$s%1$s%3$s%1$s%4$s";
        String normalizedPathFormat = "%2$s%1$s%3$s%1$s%4$s%1$s%5$s";
        String attributes = new DefaultPathPredicate(file).attributes();
        String normalizedFileName = PathNormalizer.name(file.getAbsolute());
        File shortenTestPath = new File(PreferencesFactory.get().getProperty("tmp.dir"), String.format("%2$s%1$s%3$s%1$s%4$s%1$s%5$s", this.delimiter, uid, "", attributes, normalizedFileName));
        int shortenLength = PreferencesFactory.get().getInteger("local.temporaryfiles.shortening.threshold") - shortenTestPath.getAbsolutePath().length();
        if (shortenLength < 0) {
            // empty if block
        }
        String shortenedPath = this.shorten(file.getParent().getAbsolute(), shortenLength);
        String folder = String.format("%2$s%1$s%3$s%1$s%4$s", this.delimiter, uid, shortenedPath, attributes);
        return this.create(folder, normalizedFileName);
    }

    private Local create(String folder, String name) {
        Local file = LocalFactory.get(new File(PreferencesFactory.get().getProperty("tmp.dir"), folder).getAbsolutePath(), name);
        this.delete(file.getParent());
        this.delete(file);
        return file;
    }

    protected void delete(Local file) {
        files.add(file);
    }

    protected String shorten(String path, int limit) {
        if (path.length() > limit) {
            return DigestUtils.md5Hex((String)path);
        }
        return path;
    }

    @Override
    public void shutdown() {
        ArrayList<Local> list = new ArrayList<Local>(files);
        Collections.reverse(list);
        for (Local f : list) {
            try {
                f.delete();
            }
            catch (AccessDeniedException e) {
                log.warn((Object)String.format("Failure deleting file %s in shutdown hook. %s", f, e.getMessage()));
            }
        }
    }
}

