/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local.features;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.local.features.Symlink;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class DefaultSymlinkFeature
implements Symlink {
    @Override
    public void symlink(Local file, String target) throws AccessDeniedException {
        try {
            Files.createSymbolicLink(Paths.get(file.getAbsolute(), new String[0]), Paths.get(target, new String[0]), new FileAttribute[0]);
        }
        catch (IOException | UnsupportedOperationException e) {
            throw new AccessDeniedException(String.format("%s %s", LocaleFactory.localizedString("Cannot create file", "Error"), file.getAbsolute()), e);
        }
    }
}

