/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.pool;

import ch.cyberduck.core.ConnectionService;
import ch.cyberduck.core.DisabledCancelCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.vault.VaultRegistry;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.log4j.Logger;

public class PooledSessionFactory
extends BasePooledObjectFactory<Session> {
    private static final Logger log = Logger.getLogger(PooledSessionFactory.class);
    private final ConnectionService connect;
    private final X509TrustManager trust;
    private final X509KeyManager key;
    private final PathCache cache;
    private final Host bookmark;
    private final VaultRegistry registry;

    public PooledSessionFactory(ConnectionService connect, X509TrustManager trust, X509KeyManager key, PathCache cache, Host bookmark, VaultRegistry registry) {
        this.connect = connect;
        this.trust = trust;
        this.key = key;
        this.cache = cache;
        this.bookmark = bookmark;
        this.registry = registry;
    }

    public Session create() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Create new session for host %s in pool", this.bookmark));
        }
        return SessionFactory.create(this.bookmark, this.trust, this.key).withRegistry(this.registry);
    }

    public PooledObject<Session> wrap(Session session) {
        return new DefaultPooledObject((Object)session);
    }

    public void activateObject(PooledObject<Session> p) throws BackgroundException {
        Session session = (Session)p.getObject();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Activate session %s", session));
        }
        this.connect.check(session, this.cache, new DisabledCancelCallback());
    }

    public void passivateObject(PooledObject<Session> p) throws Exception {
        Session session = (Session)p.getObject();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Pause session %s", session));
        }
    }

    public void destroyObject(PooledObject<Session> p) throws BackgroundException {
        Session session = (Session)p.getObject();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Destroy session %s", session));
        }
        session.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PooledSessionFactory{");
        sb.append("bookmark=").append(this.bookmark);
        sb.append('}');
        return sb.toString();
    }
}

