/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.pool;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.vault.VaultRegistry;

public interface SessionPool {
    public static final SessionPool DISCONNECTED = new DisconnectedSessionPool();

    public Session<?> borrow(BackgroundActionState var1) throws BackgroundException;

    public void release(Session<?> var1, BackgroundException var2);

    public void evict();

    public Host getHost();

    public PathCache getCache();

    public VaultRegistry getVault();

    public Session.State getState();

    public <T> T getFeature(Class<T> var1);

    public void shutdown();

    public static final class DisconnectedSessionPool
    implements SessionPool {
        private static final Host DISCONNECTED = new Host(ProtocolFactory.forName(PreferencesFactory.get().getProperty("connection.protocol.default")), PreferencesFactory.get().getProperty("connection.hostname.default"), PreferencesFactory.get().getInteger("connection.port.default"));

        @Override
        public Session<?> borrow(BackgroundActionState callback) throws BackgroundException {
            return null;
        }

        @Override
        public void release(Session<?> session, BackgroundException failure) {
        }

        @Override
        public void evict() {
        }

        @Override
        public Host getHost() {
            return DISCONNECTED;
        }

        @Override
        public PathCache getCache() {
            return PathCache.empty();
        }

        @Override
        public VaultRegistry getVault() {
            return VaultRegistry.DISABLED;
        }

        @Override
        public Session.State getState() {
            return Session.State.closed;
        }

        @Override
        public <T> T getFeature(Class<T> type) {
            return null;
        }

        @Override
        public void shutdown() {
        }
    }

    public static interface Callback {
        public boolean isCanceled();
    }
}

