/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.preferences;

import ch.cyberduck.core.DisabledCertificateStore;
import ch.cyberduck.core.DisabledHostKeyCallback;
import ch.cyberduck.core.DisabledLocale;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.DisabledPasswordCallback;
import ch.cyberduck.core.DisabledPasswordStore;
import ch.cyberduck.core.DisabledSleepPreventer;
import ch.cyberduck.core.DisabledTerminalService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.aquaticprime.DonationKeyFactory;
import ch.cyberduck.core.date.DefaultUserDateFormatter;
import ch.cyberduck.core.diagnostics.DefaultInetAddressReachability;
import ch.cyberduck.core.formatter.DecimalSizeFormatter;
import ch.cyberduck.core.io.watchservice.NIOEventWatchService;
import ch.cyberduck.core.local.DefaultLocalTouchFeature;
import ch.cyberduck.core.local.DefaultTemporaryFileService;
import ch.cyberduck.core.local.DefaultWorkingDirectoryFinder;
import ch.cyberduck.core.local.DisabledApplicationBadgeLabeler;
import ch.cyberduck.core.local.DisabledApplicationFinder;
import ch.cyberduck.core.local.DisabledApplicationLauncher;
import ch.cyberduck.core.local.DisabledBrowserLauncher;
import ch.cyberduck.core.local.DisabledIconService;
import ch.cyberduck.core.local.DisabledQuarantineService;
import ch.cyberduck.core.local.NativeLocalTrashFeature;
import ch.cyberduck.core.local.NullFileDescriptor;
import ch.cyberduck.core.local.NullLocalSymlinkFeature;
import ch.cyberduck.core.local.WorkingDirectoryFinderFactory;
import ch.cyberduck.core.notification.DisabledNotificationService;
import ch.cyberduck.core.preferences.ApplicationResourcesFinderFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import ch.cyberduck.core.preferences.TemporaryApplicationResourcesFinder;
import ch.cyberduck.core.preferences.TemporarySupportDirectoryFinder;
import ch.cyberduck.core.proxy.DisabledProxyFinder;
import ch.cyberduck.core.random.DefaultSecureRandomProvider;
import ch.cyberduck.core.resources.DisabledIconCache;
import ch.cyberduck.core.serializer.impl.dd.HostPlistReader;
import ch.cyberduck.core.serializer.impl.dd.PlistDeserializer;
import ch.cyberduck.core.serializer.impl.dd.PlistSerializer;
import ch.cyberduck.core.serializer.impl.dd.PlistWriter;
import ch.cyberduck.core.serializer.impl.dd.ProfilePlistReader;
import ch.cyberduck.core.serializer.impl.dd.TransferPlistReader;
import ch.cyberduck.core.threading.DefaultThreadPool;
import ch.cyberduck.core.threading.DisabledActionOperationBatcher;
import ch.cyberduck.core.threading.DisabledAlertCallback;
import ch.cyberduck.core.transfer.DisabledTransferErrorCallback;
import ch.cyberduck.core.transfer.DisabledTransferPrompt;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.updater.DisabledPeriodicUpdater;
import ch.cyberduck.core.urlhandler.DisabledSchemeHandler;
import ch.cyberduck.core.vault.DisabledVault;
import ch.cyberduck.core.webloc.InternetShortcutFileWriter;
import java.io.File;
import java.net.URL;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.xml.DOMConfigurator;
import org.slf4j.bridge.SLF4JBridgeHandler;

public abstract class Preferences {
    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(Preferences.class);
    protected final Map<String, String> defaults = new HashMap<String, String>();

    protected void post() {
        if (this.getBoolean("connection.dns.ipv6")) {
            System.setProperty("java.net.preferIPv6Addresses", String.valueOf(true));
        }
    }

    public abstract void setProperty(String var1, String var2);

    public abstract void setProperty(String var1, List<String> var2);

    public abstract void deleteProperty(String var1);

    public void setProperty(String property, boolean v) {
        this.setProperty(property, v ? String.valueOf(true) : String.valueOf(false));
    }

    public void setProperty(String property, int v) {
        this.setProperty(property, String.valueOf(v));
    }

    public void setProperty(String property, float v) {
        this.setProperty(property, String.valueOf(v));
    }

    public void setProperty(String property, long v) {
        this.setProperty(property, String.valueOf(v));
    }

    public void setProperty(String property, double v) {
        this.setProperty(property, String.valueOf(v));
    }

    protected void setDefaults() {
        this.defaults.put("application.version", Version.getSpecification());
        this.defaults.put("application.revision", Version.getImplementation());
        this.defaults.put("tmp.dir", System.getProperty("java.io.tmpdir"));
        this.defaults.put("uses", "0");
        this.defaults.put("donate.reminder", String.valueOf(-1));
        this.defaults.put("donate.reminder.interval", String.valueOf(20));
        this.defaults.put("donate.reminder.date", String.valueOf(new Date(0L).getTime()));
        this.defaults.put("defaulthandler.reminder", String.valueOf(true));
        this.defaults.put("mail.feedback", "mailto:support@cyberduck.io");
        this.defaults.put("website.donate", "https://cyberduck.io/donate/");
        this.defaults.put("website.home", "https://cyberduck.io/");
        this.defaults.put("website.help", "https://help.cyberduck.io/" + this.locale());
        this.defaults.put("website.bug", "https://trac.cyberduck.io/newticket?version={0}");
        this.defaults.put("website.crash", "https://crash.cyberduck.io/report");
        this.defaults.put("website.cli", "https://duck.sh/");
        this.defaults.put("website.license", "https://cyberduck.io/license");
        this.defaults.put("website.acknowledgments", "https://cyberduck.io/acknowledgments");
        this.defaults.put("rendezvous.enable", String.valueOf(true));
        this.defaults.put("rendezvous.loopback.suppress", String.valueOf(true));
        this.defaults.put("rendezvous.notification.limit", String.valueOf(30));
        this.defaults.put("growl.enable", String.valueOf(true));
        this.defaults.put("path.symboliclink.resolve", String.valueOf(false));
        this.defaults.put("path.normalize", String.valueOf(true));
        this.defaults.put("path.normalize.unicode", String.valueOf(false));
        this.defaults.put("local.user.home", System.getProperty("user.home"));
        this.defaults.put("local.symboliclink.resolve", String.valueOf(false));
        this.defaults.put("local.normalize.prefix", String.valueOf(false));
        this.defaults.put("local.normalize.unicode", String.valueOf(true));
        this.defaults.put("local.normalize.tilde", String.valueOf(true));
        this.defaults.put("local.list.native", String.valueOf(true));
        this.defaults.put("local.delimiter", File.separator);
        this.defaults.put("local.temporaryfiles.shortening.threshold", String.valueOf(240));
        this.defaults.put("application.name", "Cyberduck");
        String support = SupportDirectoryFinderFactory.get().find().getAbsolute();
        this.defaults.put("application.support.path", support);
        this.defaults.put("application.receipt.path", support);
        Local resources = ApplicationResourcesFinderFactory.get().find();
        this.defaults.put("application.bookmarks.path", String.format("%s/bookmarks", resources.getAbsolute()));
        this.defaults.put("application.profiles.path", String.format("%s/profiles", resources.getAbsolute()));
        this.defaults.put("bookmarks.folder.name", "Bookmarks");
        this.defaults.put("profiles.folder.name", "Profiles");
        this.defaults.put("browser.cache.size", String.valueOf(1000));
        this.defaults.put("transfer.cache.size", String.valueOf(100));
        this.defaults.put("icon.cache.size", String.valueOf(200));
        this.defaults.put("browser.model.cache.size", String.valueOf(10000));
        this.defaults.put("browser.list.limit.directory", String.valueOf(5000));
        this.defaults.put("browser.list.limit.container", String.valueOf(100));
        this.defaults.put("info.toolbar.selected", String.valueOf(0));
        this.defaults.put("preferences.toolbar.selected", String.valueOf(0));
        this.defaults.put("browser.view", "1");
        this.defaults.put("browser.serialize", String.valueOf(true));
        this.defaults.put("browser.font.size", String.valueOf(12.0f));
        this.defaults.put("browser.view.autoexpand", String.valueOf(true));
        this.defaults.put("browser.view.autoexpand.useDelay", String.valueOf(true));
        this.defaults.put("browser.view.autoexpand.delay", "1.0");
        this.defaults.put("browser.hidden.regex", "\\..*");
        this.defaults.put("browser.open.untitled", String.valueOf(true));
        this.defaults.put("browser.open.bookmark.default", null);
        this.defaults.put("browser.disconnect.confirm", String.valueOf(false));
        this.defaults.put("browser.disconnect.bookmarks.show", String.valueOf(false));
        this.defaults.put("browser.info.inspector", String.valueOf(true));
        this.defaults.put("browser.sort.ascending", String.valueOf(true));
        this.defaults.put("browser.alternatingRows", String.valueOf(false));
        this.defaults.put("browser.verticalLines", String.valueOf(false));
        this.defaults.put("browser.horizontalLines", String.valueOf(true));
        this.defaults.put("browser.showHidden", String.valueOf(false));
        this.defaults.put("browser.charset.encoding", "UTF-8");
        this.defaults.put("browser.doubleclick.edit", String.valueOf(false));
        this.defaults.put("browser.enterkey.rename", String.valueOf(true));
        this.defaults.put("browser.editable", String.valueOf(true));
        this.defaults.put("browser.move.confirm", String.valueOf(true));
        this.defaults.put("browser.transcript.open", String.valueOf(false));
        this.defaults.put("browser.transcript.size.height", String.valueOf(200));
        this.defaults.put("browser.duplicate.format", "{0} ({1}){2}");
        this.defaults.put("browser.filesize.decimal", String.valueOf(false));
        this.defaults.put("browser.date.natural", String.valueOf(true));
        this.defaults.put("browser.delete.concurrency", String.valueOf(10));
        this.defaults.put("info.toggle.permission", String.valueOf(1));
        this.defaults.put("info.toggle.distribution", String.valueOf(0));
        this.defaults.put("info.toggle.s3", String.valueOf(0));
        this.defaults.put("connection.toggle.options", String.valueOf(0));
        this.defaults.put("bookmark.toggle.options", String.valueOf(0));
        this.defaults.put("alert.toggle.transcript", String.valueOf(0));
        this.defaults.put("transfer.toggle.details", String.valueOf(1));
        this.defaults.put("editor.bundleIdentifier", "com.apple.TextEdit");
        this.defaults.put("editor.alwaysUseDefault", String.valueOf(false));
        this.defaults.put("editor.upload.permissions.change", String.valueOf(true));
        this.defaults.put("editor.upload.symboliclink.resolve", String.valueOf(true));
        this.defaults.put("favorites.save", String.valueOf(true));
        this.defaults.put("queue.removeItemWhenComplete", String.valueOf(false));
        this.defaults.put("queue.maxtransfers", String.valueOf(2));
        this.defaults.put("queue.transfer.type.enabled", String.format("%s %s %s", String.valueOf(Host.TransferType.browser.name()), String.valueOf(Host.TransferType.newconnection.name()), String.valueOf(Host.TransferType.concurrent.name())));
        this.defaults.put("queue.transfer.type", String.valueOf(Host.TransferType.concurrent.name()));
        this.defaults.put("queue.size.warn", String.valueOf(20));
        this.defaults.put("queue.window.open.default", String.valueOf(false));
        this.defaults.put("queue.window.open.transfer.start", String.valueOf(true));
        this.defaults.put("queue.window.open.transfer.stop", String.valueOf(false));
        this.defaults.put("queue.download.action", TransferAction.callback.name());
        this.defaults.put("queue.upload.action", TransferAction.callback.name());
        this.defaults.put("queue.copy.action", TransferAction.callback.name());
        this.defaults.put("queue.download.reload.action", TransferAction.callback.name());
        this.defaults.put("queue.upload.reload.action", TransferAction.callback.name());
        this.defaults.put("queue.copy.reload.action", TransferAction.callback.name());
        this.defaults.put("queue.upload.permissions.change", String.valueOf(false));
        this.defaults.put("queue.upload.permissions.default", String.valueOf(false));
        this.defaults.put("queue.upload.permissions.file.default", String.valueOf(644));
        this.defaults.put("queue.upload.permissions.folder.default", String.valueOf(755));
        this.defaults.put("queue.upload.timestamp.change", String.valueOf(false));
        this.defaults.put("queue.upload.file.metadata.change", String.valueOf(true));
        this.defaults.put("queue.upload.file.encryption.change", String.valueOf(true));
        this.defaults.put("queue.upload.file.redundancy.change", String.valueOf(true));
        this.defaults.put("queue.upload.checksum.calculate", String.valueOf(true));
        this.defaults.put("queue.upload.skip.enable", String.valueOf(true));
        this.defaults.put("queue.upload.skip.regex.default", ".*~\\..*|\\.DS_Store|\\.svn|CVS");
        this.defaults.put("queue.upload.skip.regex", ".*~\\..*|\\.DS_Store|\\.svn|CVS");
        this.defaults.put("queue.upload.priority.regex", "");
        this.defaults.put("queue.upload.file.temporary", String.valueOf(false));
        this.defaults.put("queue.upload.file.temporary.format", "{0}-{1}");
        this.defaults.put("queue.upload.file.rename.format", "{0} ({1}){2}");
        this.defaults.put("queue.download.file.rename.format", "{0} ({1}){2}");
        this.defaults.put("queue.download.permissions.change", String.valueOf(true));
        this.defaults.put("queue.download.permissions.default", String.valueOf(false));
        this.defaults.put("queue.download.permissions.file.default", String.valueOf(644));
        this.defaults.put("queue.download.permissions.folder.default", String.valueOf(755));
        this.defaults.put("queue.download.timestamp.change", String.valueOf(true));
        this.defaults.put("queue.download.checksum", String.valueOf(true));
        this.defaults.put("queue.download.skip.enable", String.valueOf(true));
        this.defaults.put("queue.download.skip.regex.default", ".*~\\..*|\\.DS_Store|\\.svn|CVS|RCS|SCCS|\\.git|\\.bzr|\\.bzrignore|\\.bzrtags|\\.hg|\\.hgignore|\\.hgtags|_darcs|\\.file-segments");
        this.defaults.put("queue.download.skip.regex", ".*~\\..*|\\.DS_Store|\\.svn|CVS|RCS|SCCS|\\.git|\\.bzr|\\.bzrignore|\\.bzrtags|\\.hg|\\.hgignore|\\.hgtags|_darcs|\\.file-segments");
        this.defaults.put("queue.download.priority.regex", "");
        this.defaults.put("queue.download.folder", WorkingDirectoryFinderFactory.get().find().getAbsolute());
        this.defaults.put("queue.download.folder.bookmark", null);
        this.defaults.put("queue.download.quarantine", String.valueOf(true));
        this.defaults.put("queue.download.wherefrom", String.valueOf(true));
        this.defaults.put("queue.download.segments", String.valueOf(false));
        this.defaults.put("queue.download.segments.threshold", String.valueOf(0x6400000L));
        this.defaults.put("queue.download.segments.size", String.valueOf(0x3200000L));
        this.defaults.put("queue.download.complete.open", String.valueOf(false));
        this.defaults.put("queue.dock.badge", String.valueOf(false));
        this.defaults.put("queue.sleep.prevent", String.valueOf(true));
        StringBuilder options = new StringBuilder();
        options.append(5L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(10L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(20L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(50L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(100L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(150L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(200L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(500L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(1L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(2L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(5L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(10L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(15L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(20L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(50L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(100L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        this.defaults.put("queue.bandwidth.options", options.toString());
        this.defaults.put("queue.upload.bandwidth.bytes", String.valueOf(-1));
        this.defaults.put("queue.download.bandwidth.bytes", String.valueOf(-1));
        this.defaults.put("queue.connections.limit", String.valueOf(2));
        options = new StringBuilder();
        options.append(1).append(",");
        options.append(2).append(",");
        options.append(3).append(",");
        options.append(4).append(",");
        options.append(5).append(",");
        options.append(10).append(",");
        options.append(15).append(",");
        options.append(20).append(",");
        this.defaults.put("queue.connections.options", options.toString());
        this.defaults.put("queue.download.icon.update", String.valueOf(true));
        this.defaults.put("queue.download.icon.threshold", String.valueOf(0x500000L));
        this.defaults.put("queue.prompt.sync.action.default", TransferAction.mirror.name());
        this.defaults.put("queue.prompt.download.action.default", TransferAction.overwrite.name());
        this.defaults.put("queue.prompt.upload.action.default", TransferAction.overwrite.name());
        this.defaults.put("queue.prompt.copy.action.default", TransferAction.overwrite.name());
        this.defaults.put("queue.prompt.move.action.default", TransferAction.overwrite.name());
        this.defaults.put("queue.transcript.open", String.valueOf(false));
        this.defaults.put("queue.transcript.size.height", String.valueOf(200));
        this.defaults.put("http.compression.enable", String.valueOf(true));
        this.defaults.put("http.connections.route", String.valueOf(10));
        this.defaults.put("http.connections.reuse", String.valueOf(true));
        this.defaults.put("http.connections.total", String.valueOf(Integer.MAX_VALUE));
        this.defaults.put("http.connections.retry", String.valueOf(1));
        this.defaults.put("http.manager.timeout", String.valueOf(0));
        this.defaults.put("http.socket.buffer", String.valueOf(8192));
        this.defaults.put("http.credentials.charset", "ISO-8859-1");
        this.defaults.put("ftp.datachannel.verify", String.valueOf(false));
        this.defaults.put("ftp.socket.buffer", String.valueOf(0));
        this.defaults.put("ftp.parser.multiline.strict", String.valueOf(false));
        this.defaults.put("ftp.parser.reply.strict", String.valueOf(false));
        this.defaults.put("ftp.command.lista", String.valueOf(true));
        this.defaults.put("ftp.command.stat", String.valueOf(true));
        this.defaults.put("ftp.command.mlsd", String.valueOf(true));
        this.defaults.put("ftp.connectmode.fallback", String.valueOf(true));
        this.defaults.put("ftp.tls.datachannel", "P");
        this.defaults.put("ftp.tls.session.requirereuse", String.valueOf(true));
        this.defaults.put("ftp.ssl.session.cache.size", String.valueOf(100));
        this.defaults.put("ftp.timezone.auto", String.valueOf(false));
        this.defaults.put("ftp.timezone.default", TimeZone.getDefault().getID());
        this.defaults.put("ftp.symlink.absolute", String.valueOf(false));
        this.defaults.put("s3.signature.version", "AWS4HMACSHA256");
        this.defaults.put("s3.location", "us-east-1");
        this.defaults.put("s3.bucket.virtualhost.disable", String.valueOf(false));
        this.defaults.put("s3.bucket.requesterpays", String.valueOf(true));
        this.defaults.put("s3.domain", "amazonaws.com");
        this.defaults.put("s3.hostname.default", "s3.amazonaws.com");
        this.defaults.put("s3.bucket.acl.default", "public-read");
        this.defaults.put("s3.key.acl.default", "public-read");
        this.defaults.put("s3.storage.class", "STANDARD");
        this.defaults.put("s3.encryption.algorithm", "");
        this.defaults.put("s3.url.expire.seconds", String.valueOf(86400));
        this.defaults.put("s3.mfa.serialnumber", "");
        this.defaults.put("s3.listing.chunksize", String.valueOf(1000));
        this.defaults.put("s3.revisions.enable", String.valueOf(true));
        this.defaults.put("s3.upload.md5", String.valueOf(true));
        this.defaults.put("s3.upload.multipart", String.valueOf(true));
        this.defaults.put("s3.upload.multipart.concurrency", String.valueOf(10));
        this.defaults.put("s3.upload.multipart.partsize.minimum", String.valueOf(0x500000L));
        this.defaults.put("s3.upload.multipart.threshold", String.valueOf(0x6400000L));
        this.defaults.put("s3.upload.multipart.required.threshold", String.valueOf(0x140000000L));
        this.defaults.put("s3.upload.multipart.size", String.valueOf(0xA00000L));
        this.defaults.put("s3.upload.expect-continue", String.valueOf(true));
        this.defaults.put("s3.download.udt.threshold", String.valueOf(Long.MAX_VALUE));
        this.defaults.put("s3.upload.udt.threshold", String.valueOf(Long.MAX_VALUE));
        this.defaults.put("s3.accelerate.prompt", String.valueOf(false));
        this.defaults.put("s3.logging.prefix", "logs/");
        this.defaults.put("google.logging.prefix", "log");
        this.defaults.put("cloudfront.logging.prefix", "logs/");
        this.defaults.put("googlestorage.oauth.clientid", "996125414232.apps.googleusercontent.com");
        this.defaults.put("googlestorage.oauth.secret", "YdaFjo2t74-Q0sThsXgeTv3l");
        this.defaults.put("googlestorage.oauth.redirecturi", "urn:ietf:wg:oauth:2.0:oob");
        this.defaults.put("hubic.oauth.clientid", "api_hubic_Hoh1lpzGzsLxUV6VKI3BuiFcyJECBEPH");
        this.defaults.put("hubic.oauth.secret", "IIm0EkjdyPquS9SpIZXAdNlGbcf3mL9s3UiOFLnWLeTxLosjvAHGIbomvAcBZQb2");
        this.defaults.put("hubic.oauth.redirecturi", "https://cyberduck.io/oauth");
        this.defaults.put("onedrive.oauth.clientid", "372770ba-bb24-436b-bbd4-19bc86310c0e");
        this.defaults.put("onedrive.oauth.secret", "mJjWVkmfD9FVHNFTpbrdowv");
        this.defaults.put("onedrive.oauth.redirecturi", "https://cyberduck.io/oauth/");
        this.defaults.put("onedrive.upload.multipart.partsize.minimum", String.valueOf(327680));
        int month = 2592000;
        this.defaults.put("s3.cache.seconds", String.valueOf(2592000));
        this.defaults.put("s3.metadata.default", "");
        this.defaults.put("s3.lifecycle.transition.options", "1 7 10 30 60 180 360 720");
        this.defaults.put("s3.lifecycle.delete.options", "1 7 10 30 60 180 360 720");
        this.defaults.put("s3.delete.multiple.partition", String.valueOf(1000));
        this.defaults.put("azure.metadata.default", "");
        this.defaults.put("azure.listing.chunksize", String.valueOf(1000));
        this.defaults.put("azure.upload.md5", String.valueOf(false));
        this.defaults.put("openstack.authentication.context", "/v2.0/tokens");
        this.defaults.put("openstack.upload.metadata.md5", String.valueOf(false));
        this.defaults.put("openstack.metadata.default", "");
        this.defaults.put("openstack.list.container.limit", String.valueOf(100));
        this.defaults.put("openstack.list.object.limit", String.valueOf(10000));
        this.defaults.put("openstack.account.preload", String.valueOf(true));
        this.defaults.put("openstack.cdn.preload", String.valueOf(true));
        this.defaults.put("openstack.container.size.preload", String.valueOf(true));
        this.defaults.put("openstack.upload.md5", String.valueOf(true));
        this.defaults.put("openstack.upload.largeobject", String.valueOf(true));
        this.defaults.put("openstack.upload.largeobject.concurrency", String.valueOf(5));
        this.defaults.put("openstack.upload.largeobject.segments.prefix", ".file-segments/");
        this.defaults.put("openstack.upload.largeobject.threshold", String.valueOf(0x80000000L));
        this.defaults.put("openstack.upload.largeobject.required.threshold", String.valueOf(0x140000000L));
        this.defaults.put("openstack.upload.largeobject.size", String.valueOf(1048576000L));
        this.defaults.put("openstack.upload.largeobject.size.minimum", String.valueOf(0x100000L));
        this.defaults.put("openstack.upload.largeobject.cleanup", String.valueOf(true));
        this.defaults.put("openstack.delete.multiple.partition", String.valueOf(10000));
        this.defaults.put("googledrive.oauth.clientid", "996125414232.apps.googleusercontent.com");
        this.defaults.put("googledrive.oauth.clientsecret", "YdaFjo2t74-Q0sThsXgeTv3l");
        this.defaults.put("googledrive.oauth.redirecturi", "urn:ietf:wg:oauth:2.0:oob");
        this.defaults.put("googledrive.list.limit", String.valueOf(1000));
        this.defaults.put("b2.bucket.acl.default", "allPrivate");
        this.defaults.put("b2.listing.chunksize", String.valueOf(100));
        this.defaults.put("b2.upload.checksum.verify", String.valueOf(true));
        this.defaults.put("b2.upload.largeobject", String.valueOf(true));
        this.defaults.put("b2.upload.largeobject.concurrency", String.valueOf(5));
        this.defaults.put("b2.upload.largeobject.required.threshold", String.valueOf(0x140000000L));
        this.defaults.put("b2.upload.largeobject.threshold", String.valueOf(0xC800000L));
        this.defaults.put("b2.upload.largeobject.size", String.valueOf(0x6400000L));
        this.defaults.put("b2.upload.largeobject.size.minimum", String.valueOf(0x500000L));
        this.defaults.put("b2.metadata.default", "");
        this.defaults.put("webdav.ntlm.domain", "");
        this.defaults.put("webdav.ntlm.workstation", "");
        this.defaults.put("webdav.basic.preemptive", String.valueOf(true));
        this.defaults.put("webdav.expect-continue", String.valueOf(true));
        this.defaults.put("webdav.redirect.GET.follow", String.valueOf(true));
        this.defaults.put("webdav.redirect.HEAD.follow", String.valueOf(true));
        this.defaults.put("webdav.redirect.PUT.follow", String.valueOf(false));
        this.defaults.put("webdav.redirect.PROPFIND.follow", String.valueOf(true));
        this.defaults.put("webdav.upload.md5", String.valueOf(false));
        this.defaults.put("webdav.metadata.default", "");
        this.defaults.put("analytics.provider.qloudstat.setup", "https://qloudstat.com/configuration/add");
        this.defaults.put("analytics.provider.qloudstat.iam.policy", "{\n    \"Statement\": [\n        {\n            \"Action\": [\n                \"s3:GetObject\", \n                \"s3:ListBucket\"\n            ], \n            \"Condition\": {\n                \"Bool\": {\n                    \"aws:SecureTransport\": \"true\"\n                }\n            }, \n            \"Effect\": \"Allow\", \n            \"Resource\": \"arn:aws:s3:::%s/*\"\n        }, \n        {\n            \"Action\": [\n                \"s3:ListAllMyBuckets\", \n                \"s3:GetBucketLogging\", \n                \"s3:GetBucketLocation\"\n            ], \n            \"Effect\": \"Allow\", \n            \"Resource\": \"arn:aws:s3:::*\"\n        }, \n        {\n            \"Action\": [\n                \"cloudfront:GetDistribution\", \n                \"cloudfront:GetDistributionConfig\", \n                \"cloudfront:ListDistributions\", \n                \"cloudfront:GetStreamingDistribution\", \n                \"cloudfront:GetStreamingDistributionConfig\", \n                \"cloudfront:ListStreamingDistributions\"\n            ], \n            \"Condition\": {\n                \"Bool\": {\n                    \"aws:SecureTransport\": \"true\"\n                }\n            }, \n            \"Effect\": \"Allow\", \n            \"Resource\": \"*\"\n        }\n    ]\n}\n");
        this.defaults.put("connection.pool.minidle", String.valueOf(1));
        this.defaults.put("connection.pool.maxidle", String.valueOf(5));
        this.defaults.put("connection.pool.maxtotal", String.valueOf(Integer.MAX_VALUE));
        this.defaults.put("connection.login.name", "");
        this.defaults.put("connection.login.anon.name", "anonymous");
        this.defaults.put("connection.login.anon.pass", "cyberduck@example.net");
        this.defaults.put("connection.login.keychain", String.valueOf(true));
        this.defaults.put("vault.keychain", String.valueOf(false));
        this.defaults.put("connection.port.default", String.valueOf(21));
        this.defaults.put("connection.protocol.default", Scheme.ftp.name());
        this.defaults.put("connection.socket.keepalive", String.valueOf(true));
        this.defaults.put("connection.socket.linger", String.valueOf(false));
        this.defaults.put("connection.timeout.seconds", String.valueOf(30));
        this.defaults.put("connection.retry", String.valueOf(1));
        this.defaults.put("connection.retry.delay", String.valueOf(0));
        this.defaults.put("connection.retry.backoff.enable", String.valueOf(false));
        this.defaults.put("connection.hostname.default", "");
        this.defaults.put("connection.hostname.idn", String.valueOf(true));
        this.defaults.put("connection.dns.ipv6", String.valueOf(false));
        this.defaults.put("connection.proxy.enable", String.valueOf(true));
        this.defaults.put("connection.proxy.ntlm.domain", "");
        this.defaults.put(String.format("connection.unsecure.warning.%s", new Object[]{Scheme.ftp}), String.valueOf(true));
        this.defaults.put(String.format("connection.unsecure.warning.%s", new Object[]{Scheme.http}), String.valueOf(true));
        this.defaults.put("connection.ssl.provider.bouncycastle.position", String.valueOf(1));
        this.defaults.put("connection.ssl.protocols", "TLSv1.2,TLSv1.1,TLSv1");
        this.defaults.put("connection.ssl.cipher.blacklist", "");
        this.defaults.put("connection.ssl.x509.revocation.online", String.valueOf(false));
        this.defaults.put("connection.ssl.keystore.type", null);
        this.defaults.put("connection.ssl.keystore.provider", null);
        this.defaults.put("connection.ssl.securerandom.algorithm", "NativePRNG");
        this.defaults.put("connection.ssl.securerandom.provider", "SUN");
        this.defaults.put("connection.chunksize", String.valueOf(32768));
        this.defaults.put("connection.buffer", String.valueOf(8192));
        this.defaults.put("connection.buffer.send", String.valueOf(0));
        this.defaults.put("connection.buffer.receive", String.valueOf(0));
        this.defaults.put("disk.unmount.timeout", String.valueOf(2));
        this.defaults.put("bookmark.favicon.download", String.valueOf(true));
        this.defaults.put("bookmark.icon.size", String.valueOf(64));
        this.defaults.put("bookmark.menu.icon.size", String.valueOf(16));
        this.defaults.put("ssh.knownhosts", "~/.ssh/known_hosts");
        this.defaults.put("ssh.knownhosts.bookmark", "");
        this.defaults.put("ssh.authentication.publickey.default.enable", String.valueOf(false));
        this.defaults.put("ssh.authentication.publickey.default.rsa", "~/.ssh/id_rsa");
        this.defaults.put("ssh.authentication.publickey.default.dsa", "~/.ssh/id_dsa");
        this.defaults.put("ssh.authentication.agent.enable", String.valueOf(true));
        this.defaults.put("ssh.heartbeat.provider", "keep-alive");
        this.defaults.put("ssh.heartbeat.seconds", String.valueOf(60));
        this.defaults.put("ssh.compression", "zlib");
        this.defaults.put("ssh.algorithm.cipher.blacklist", "");
        this.defaults.put("ssh.algorithm.mac.blacklist", "");
        this.defaults.put("ssh.algorithm.kex.blacklist", "");
        this.defaults.put("ssh.algorithm.signature.blacklist", "");
        this.defaults.put("sftp.symlink.absolute", String.valueOf(false));
        this.defaults.put("sftp.read.maxunconfirmed", String.valueOf(64));
        this.defaults.put("sftp.write.maxunconfirmed", String.valueOf(64));
        this.defaults.put("archive.default", "tar.gz");
        this.defaults.put("archive.command.create.tar", "cd {2}; tar -cpPf {0}.tar {1}");
        this.defaults.put("archive.command.create.tar.gz", "cd {2}; tar -czpPf {0}.tar.gz {1}");
        this.defaults.put("archive.command.create.tar.bz2", "cd {2}; tar -cjpPf {0}.tar.bz2 {1}");
        this.defaults.put("archive.command.create.zip", "cd {2}; zip -qr {0}.zip {1}");
        this.defaults.put("archive.command.create.gz", "gzip -qr {1}");
        this.defaults.put("archive.command.create.bz2", "bzip2 -zk {1}");
        this.defaults.put("archive.command.expand.tar", "tar -xpPf {0} -C {1}");
        this.defaults.put("archive.command.expand.tar.gz", "tar -xzpPf {0} -C {1}");
        this.defaults.put("archive.command.expand.tar.bz2", "tar -xjpPf {0} -C {1}");
        this.defaults.put("archive.command.expand.zip", "unzip -qn {0} -d {1}");
        this.defaults.put("archive.command.expand.gz", "gzip -d {0}");
        this.defaults.put("archive.command.expand.bz2", "bzip2 -dk {0}");
        this.defaults.put("update.check", String.valueOf(true));
        int day = 86400;
        this.defaults.put("update.check.interval", String.valueOf(86400));
        this.defaults.put("update.check.timestamp", String.valueOf(0));
        this.defaults.put("terminal.bundle.identifier", "com.apple.Terminal");
        this.defaults.put("terminal.command", "do script \"{0}\"");
        this.defaults.put("terminal.command.ssh", "ssh -t {0} {1}@{2} -p {3} \"cd {4} && exec \\$SHELL\"");
        this.defaults.put("network.interface.blacklist", "");
        this.defaults.put("threading.pool.size.max", String.valueOf(20));
        this.defaults.put("threading.pool.keepalive.seconds", String.valueOf(60L));
        this.defaults.put("dropbox.oauth.clientid", "rjqgs45ntjp1va9");
        this.defaults.put("dropbox.oauth.clientsecret", "yg1uopbf5c1h1rk");
        this.defaults.put("dropbox.oauth.redirecturi", "https://cyberduck.io/oauth");
        this.defaults.put("cryptomator.enable", String.valueOf(true));
        this.defaults.put("cryptomator.vault.autodetect", String.valueOf(true));
    }

    protected void setLogging() {
        org.apache.log4j.Logger root;
        Logger.getLogger("").setLevel(Level.ALL);
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        String file = this.defaults.get("logging.config");
        URL configuration = null == file ? Preferences.class.getClassLoader().getResource("log4j-default.xml") : Preferences.class.getClassLoader().getResource(file);
        if (null != configuration) {
            DOMConfigurator.configure((URL)configuration);
        } else {
            root = org.apache.log4j.Logger.getRootLogger();
            root.setLevel(org.apache.log4j.Level.ERROR);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getProperty("logging"))) {
            root = org.apache.log4j.Logger.getRootLogger();
            root.setLevel(org.apache.log4j.Level.toLevel((String)this.getProperty("logging"), (org.apache.log4j.Level)org.apache.log4j.Level.ERROR));
        }
    }

    public String getDefault(String property) {
        String value = this.defaults.get(property);
        if (null == value) {
            log.warn((Object)String.format("No property with key '%s'", property));
        }
        return value;
    }

    public List<String> getList(String property) {
        String value = this.getProperty(property);
        if (StringUtils.isBlank((CharSequence)value)) {
            return Collections.emptyList();
        }
        return Arrays.asList(value.split("(?<!\\\\)\\p{javaWhitespace}+"));
    }

    public Map<String, String> getMap(String property) {
        List<String> list = this.getList(property);
        HashMap<String, String> table = new HashMap<String, String>();
        for (String m : list) {
            if (StringUtils.isBlank((CharSequence)m)) continue;
            if (!m.contains("=")) {
                log.warn((Object)String.format("Invalid header %s", m));
                continue;
            }
            int split = m.indexOf(61);
            String key = m.substring(0, split);
            if (StringUtils.isBlank((CharSequence)key)) {
                log.warn((Object)String.format("Missing key in %s", m));
                continue;
            }
            String value = m.substring(split + 1);
            if (StringUtils.isEmpty((CharSequence)value)) {
                log.warn((Object)String.format("Missing value in %s", m));
                continue;
            }
            table.put(key, value);
        }
        return table;
    }

    public abstract String getProperty(String var1);

    public int getInteger(String property) {
        String v = this.getProperty(property);
        if (null == v) {
            return -1;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return (int)this.getDouble(property);
        }
    }

    public float getFloat(String property) {
        String v = this.getProperty(property);
        if (null == v) {
            return -1.0f;
        }
        try {
            return Float.parseFloat(v);
        }
        catch (NumberFormatException e) {
            return (float)this.getDouble(property);
        }
    }

    public long getLong(String property) {
        String v = this.getProperty(property);
        if (null == v) {
            return -1L;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            return (long)this.getDouble(property);
        }
    }

    public double getDouble(String property) {
        String v = this.getProperty(property);
        if (null == v) {
            return -1.0;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    public boolean getBoolean(String property) {
        String v = this.getProperty(property);
        if (null == v) {
            return false;
        }
        if (v.equalsIgnoreCase(String.valueOf(true))) {
            return true;
        }
        if (v.equalsIgnoreCase(String.valueOf(false))) {
            return false;
        }
        if (v.equalsIgnoreCase(String.valueOf(1))) {
            return true;
        }
        if (v.equalsIgnoreCase(String.valueOf(0))) {
            return false;
        }
        return v.equalsIgnoreCase("yes");
    }

    protected void setFactories() {
        this.defaults.put("factory.serializer.class", PlistSerializer.class.getName());
        this.defaults.put("factory.deserializer.class", PlistDeserializer.class.getName());
        this.defaults.put("factory.reader.profile.class", ProfilePlistReader.class.getName());
        this.defaults.put("factory.writer.profile.class", PlistWriter.class.getName());
        this.defaults.put("factory.reader.transfer.class", TransferPlistReader.class.getName());
        this.defaults.put("factory.writer.transfer.class", PlistWriter.class.getName());
        this.defaults.put("factory.reader.host.class", HostPlistReader.class.getName());
        this.defaults.put("factory.writer.host.class", PlistWriter.class.getName());
        this.defaults.put("factory.locale.class", DisabledLocale.class.getName());
        this.defaults.put("factory.local.class", Local.class.getName());
        this.defaults.put("factory.certificatestore.class", DisabledCertificateStore.class.getName());
        this.defaults.put("factory.logincallback.class", DisabledLoginCallback.class.getName());
        this.defaults.put("factory.passwordcallback.class", DisabledPasswordCallback.class.getName());
        this.defaults.put("factory.alertcallback.class", DisabledAlertCallback.class.getName());
        this.defaults.put("factory.hostkeycallback.class", DisabledHostKeyCallback.class.getName());
        this.defaults.put("factory.transfererrorcallback.class", DisabledTransferErrorCallback.class.getName());
        this.defaults.put("factory.temporaryfiles.class", DefaultTemporaryFileService.class.getName());
        this.defaults.put("factory.touch.class", DefaultLocalTouchFeature.class.getName());
        this.defaults.put("factory.autorelease.class", DisabledActionOperationBatcher.class.getName());
        this.defaults.put("factory.schemehandler.class", DisabledSchemeHandler.class.getName());
        this.defaults.put("factory.iconservice.class", DisabledIconService.class.getName());
        this.defaults.put("factory.iconcache.class", DisabledIconCache.class.getName());
        this.defaults.put("factory.notification.class", DisabledNotificationService.class.getName());
        this.defaults.put("factory.sleeppreventer.class", DisabledSleepPreventer.class.getName());
        this.defaults.put("factory.quarantine.class", DisabledQuarantineService.class.getName());
        for (Transfer.Type t : Transfer.Type.values()) {
            this.defaults.put(String.format("factory.transferpromptcallback.%s.class", t.name()), DisabledTransferPrompt.class.getName());
        }
        this.defaults.put("factory.supportdirectoryfinder.class", TemporarySupportDirectoryFinder.class.getName());
        this.defaults.put("factory.applicationresourcesfinder.class", TemporaryApplicationResourcesFinder.class.getName());
        this.defaults.put("factory.workingdirectory.class", DefaultWorkingDirectoryFinder.class.getName());
        this.defaults.put("factory.watchservice.class", NIOEventWatchService.class.getName());
        this.defaults.put("factory.proxy.class", DisabledProxyFinder.class.getName());
        this.defaults.put("factory.passwordstore.class", DisabledPasswordStore.class.getName());
        this.defaults.put("factory.dateformatter.class", DefaultUserDateFormatter.class.getName());
        this.defaults.put("factory.trash.class", NativeLocalTrashFeature.class.getName());
        this.defaults.put("factory.symlink.class", NullLocalSymlinkFeature.class.getName());
        this.defaults.put("factory.licensefactory.class", DonationKeyFactory.class.getName());
        this.defaults.put("factory.badgelabeler.class", DisabledApplicationBadgeLabeler.class.getName());
        this.defaults.put("factory.filedescriptor.class", NullFileDescriptor.class.getName());
        this.defaults.put("factory.terminalservice.class", DisabledTerminalService.class.getName());
        this.defaults.put("factory.applicationfinder.class", DisabledApplicationFinder.class.getName());
        this.defaults.put("factory.applicationlauncher.class", DisabledApplicationLauncher.class.getName());
        this.defaults.put("factory.browserlauncher.class", DisabledBrowserLauncher.class.getName());
        this.defaults.put("factory.reachability.class", DefaultInetAddressReachability.class.getName());
        this.defaults.put("factory.updater.class", DisabledPeriodicUpdater.class.getName());
        this.defaults.put("factory.threadpool.class", DefaultThreadPool.class.getName());
        this.defaults.put("factory.urlfilewriter.class", InternetShortcutFileWriter.class.getName());
        this.defaults.put("factory.vault.class", DisabledVault.class.getName());
        this.defaults.put("factory.securerandom.class", DefaultSecureRandomProvider.class.getName());
    }

    public abstract void save();

    public abstract void load();

    public String locale() {
        return this.applicationLocales().iterator().next();
    }

    public abstract List<String> applicationLocales();

    public abstract List<String> systemLocales();

    public String getDisplayName(String locale) {
        Locale l = StringUtils.contains((CharSequence)locale, (CharSequence)"_") ? new Locale(locale.split("_")[0], locale.split("_")[1]) : new Locale(locale);
        return StringUtils.capitalize((String)l.getDisplayName(l));
    }

    static {
        Security.setProperty("networkaddress.cache.ttl", "10");
        Security.setProperty("networkaddress.cache.negative.ttl", "5");
    }

    private static final class Version {
        private Version() {
        }

        public static String getSpecification() {
            Package pkg = Version.class.getPackage();
            return pkg == null ? null : pkg.getSpecificationVersion();
        }

        public static String getImplementation() {
            Package pkg = Version.class.getPackage();
            return pkg == null ? null : pkg.getImplementationVersion();
        }

        public static void main(String[] args) {
            System.out.println("Version: " + Version.getSpecification());
            System.out.println("Implementation: " + Version.getImplementation());
        }
    }
}

