/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.LocalDictionary;
import ch.cyberduck.core.serializer.PathDictionary;
import java.util.Date;
import java.util.EnumSet;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class HostDictionary {
    private static final Logger log = Logger.getLogger(HostDictionary.class);
    private final DeserializerFactory deserializer;
    private final ProtocolFactory protocols;

    public HostDictionary() {
        this(ProtocolFactory.global);
    }

    public HostDictionary(ProtocolFactory protocols) {
        this(protocols, new DeserializerFactory());
    }

    public HostDictionary(DeserializerFactory deserializer) {
        this(ProtocolFactory.global, deserializer);
    }

    public HostDictionary(ProtocolFactory protocols, DeserializerFactory deserializer) {
        this.protocols = protocols;
        this.deserializer = deserializer;
    }

    public <T> Host deserialize(T serialized) {
        Deserializer dict = this.deserializer.create(serialized);
        String protocolObj = dict.stringForKey("Protocol");
        if (protocolObj == null) {
            log.warn((Object)String.format("Missing protocol key in %s", serialized));
            return null;
        }
        Protocol p = this.protocols.find(protocolObj.toString());
        if (null != p) {
            String readonlyObj;
            String volumeObj;
            String accessObj;
            String urlObj;
            String commentObj;
            String timezoneObj;
            Object uploadObj;
            Object downloadObj;
            String transferObj;
            String connectModeObj;
            String encodingObj;
            String nicknameObj;
            Object workdirObj;
            String workdirObjDeprecated;
            String pathObj;
            String portObj;
            String certObj;
            Object keyObj;
            String keyObjDeprecated;
            String cdnCredentialsObj;
            String usernameObj;
            String providerObj;
            String uuidObj;
            Host bookmark = new Host(p);
            String hostnameObj = dict.stringForKey("Hostname");
            if (hostnameObj != null) {
                bookmark.setHostname(hostnameObj.toString());
            }
            if ((uuidObj = dict.stringForKey("UUID")) != null) {
                bookmark.setUuid(uuidObj.toString());
            }
            if ((providerObj = dict.stringForKey("Provider")) != null) {
                Protocol provider = ProtocolFactory.forName(providerObj.toString());
                if (null != provider) {
                    bookmark.setProtocol(provider);
                } else {
                    log.warn((Object)String.format("Provider %s no more available. Default to %s", providerObj, bookmark.getProtocol()));
                }
            }
            if ((usernameObj = dict.stringForKey("Username")) != null) {
                bookmark.getCredentials().setUsername(usernameObj.toString());
            }
            if ((cdnCredentialsObj = dict.stringForKey("CDN Credentials")) != null) {
                bookmark.getCdnCredentials().setUsername(cdnCredentialsObj.toString());
            }
            if ((keyObjDeprecated = dict.stringForKey("Private Key File")) != null) {
                bookmark.getCredentials().setIdentity(LocalFactory.get(keyObjDeprecated));
            }
            if ((keyObj = dict.objectForKey("Private Key File Dictionary")) != null) {
                bookmark.getCredentials().setIdentity(new LocalDictionary(this.deserializer).deserialize(keyObj));
            }
            if ((certObj = dict.stringForKey("Client Certificate")) != null) {
                bookmark.getCredentials().setCertificate(certObj.toString());
            }
            if ((portObj = dict.stringForKey("Port")) != null) {
                bookmark.setPort(Integer.parseInt(portObj.toString()));
            }
            if ((pathObj = dict.stringForKey("Path")) != null) {
                bookmark.setDefaultPath(pathObj.toString());
            }
            if ((workdirObjDeprecated = dict.stringForKey("Workdir")) != null) {
                bookmark.setWorkdir(new Path(workdirObjDeprecated.toString(), EnumSet.of(AbstractPath.Type.directory)));
            }
            if ((workdirObj = dict.objectForKey("Workdir Dictionary")) != null) {
                bookmark.setWorkdir(new PathDictionary(this.deserializer).deserialize(workdirObj));
            }
            if ((nicknameObj = dict.stringForKey("Nickname")) != null) {
                bookmark.setNickname(nicknameObj.toString());
            }
            if ((encodingObj = dict.stringForKey("Encoding")) != null) {
                bookmark.setEncoding(encodingObj.toString());
            }
            if ((connectModeObj = dict.stringForKey("FTP Connect Mode")) != null) {
                bookmark.setFTPConnectMode(FTPConnectMode.valueOf(connectModeObj.toString()));
            }
            if ((transferObj = dict.stringForKey("Transfer Connection")) != null) {
                Host.TransferType transfer = Host.TransferType.valueOf(transferObj.toString());
                if (PreferencesFactory.get().getList("queue.transfer.type.enabled").contains(transfer.name())) {
                    bookmark.setTransfer(transfer);
                }
            } else {
                String connObj = dict.stringForKey("Maximum Connections");
                if (connObj != null && 1 == Integer.valueOf(connObj.toString())) {
                    bookmark.setTransfer(Host.TransferType.browser);
                }
            }
            String downloadObjDeprecated = dict.stringForKey("Download Folder");
            if (downloadObjDeprecated != null) {
                bookmark.setDownloadFolder(LocalFactory.get(downloadObjDeprecated.toString()));
            }
            if ((downloadObj = dict.objectForKey("Download Folder Dictionary")) != null) {
                bookmark.setDownloadFolder(new LocalDictionary(this.deserializer).deserialize(downloadObj));
            }
            if ((uploadObj = dict.objectForKey("Upload Folder Dictionary")) != null) {
                bookmark.setUploadFolder(new LocalDictionary(this.deserializer).deserialize(uploadObj));
            }
            if ((timezoneObj = dict.stringForKey("Timezone")) != null) {
                bookmark.setTimezone(TimeZone.getTimeZone(timezoneObj.toString()));
            }
            if ((commentObj = dict.stringForKey("Comment")) != null) {
                bookmark.setComment(commentObj.toString());
            }
            if ((urlObj = dict.stringForKey("Web URL")) != null) {
                bookmark.setWebURL(urlObj.toString());
            }
            if ((accessObj = dict.stringForKey("Access Timestamp")) != null) {
                bookmark.setTimestamp(new Date(Long.parseLong(accessObj.toString())));
            }
            if ((volumeObj = dict.stringForKey("Volume")) != null) {
                bookmark.setVolume(LocalFactory.get(volumeObj.toString()));
            }
            if ((readonlyObj = dict.stringForKey("Readonly")) != null) {
                bookmark.setReadonly(Boolean.valueOf(readonlyObj.toString()));
            }
            return bookmark;
        }
        log.warn((Object)String.format("No protocol registered for identifier %s", protocolObj));
        return null;
    }
}

