/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import java.util.EnumSet;

public class PathDictionary {
    private final DeserializerFactory deserializer;

    public PathDictionary() {
        this.deserializer = new DeserializerFactory();
    }

    public PathDictionary(DeserializerFactory deserializer) {
        this.deserializer = deserializer;
    }

    public <T> Path deserialize(T serialized) {
        Path path;
        Object attributesObj;
        Deserializer dict = this.deserializer.create(serialized);
        EnumSet<AbstractPath.Type> type = EnumSet.noneOf(AbstractPath.Type.class);
        String typeObj = dict.stringForKey("Type");
        if (typeObj != null) {
            for (String t : typeObj.replace("[", "").replace("]", "").split(", ")) {
                type.add(AbstractPath.Type.valueOf(t));
            }
        }
        if ((attributesObj = dict.objectForKey("Attributes")) != null) {
            PathAttributes attributes = new PathAttributesDictionary(this.deserializer).deserialize(attributesObj);
            String legacyTypeObj = this.deserializer.create(attributesObj).stringForKey("Type");
            if (legacyTypeObj != null) {
                if ((Integer.valueOf(legacyTypeObj) & AbstractPath.Type.file.legacy()) == AbstractPath.Type.file.legacy()) {
                    type.add(AbstractPath.Type.file);
                }
                if ((Integer.valueOf(legacyTypeObj) & AbstractPath.Type.directory.legacy()) == AbstractPath.Type.directory.legacy()) {
                    type.add(AbstractPath.Type.directory);
                }
                if ((Integer.valueOf(legacyTypeObj) & AbstractPath.Type.symboliclink.legacy()) == AbstractPath.Type.symboliclink.legacy()) {
                    type.add(AbstractPath.Type.symboliclink);
                }
                if ((Integer.valueOf(legacyTypeObj) & AbstractPath.Type.volume.legacy()) == AbstractPath.Type.volume.legacy()) {
                    type.add(AbstractPath.Type.volume);
                }
            }
            if (type.isEmpty()) {
                return null;
            }
            String absolute = dict.stringForKey("Remote");
            if (null == absolute) {
                return null;
            }
            path = new Path(absolute, type, attributes);
        } else {
            if (type.isEmpty()) {
                return null;
            }
            String absolute = dict.stringForKey("Remote");
            if (null == absolute) {
                return null;
            }
            path = new Path(absolute, type);
        }
        Object symlinkObj = dict.objectForKey("Symbolic Link");
        if (symlinkObj != null) {
            path.setSymlinkTarget(new PathDictionary(this.deserializer).deserialize(symlinkObj));
        }
        return path;
    }
}

