/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer;

import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.LocalDictionary;
import ch.cyberduck.core.serializer.PathDictionary;
import ch.cyberduck.core.transfer.TransferItem;

public class TransferItemDictionary {
    private final DeserializerFactory deserializer;

    public TransferItemDictionary() {
        this.deserializer = new DeserializerFactory();
    }

    public TransferItemDictionary(DeserializerFactory deserializer) {
        this.deserializer = deserializer;
    }

    public <T> TransferItem deserialize(T serialized) {
        Deserializer dict = this.deserializer.create(serialized);
        Path remote = new PathDictionary(this.deserializer).deserialize(dict.objectForKey("Remote"));
        if (null == remote) {
            return null;
        }
        Object localObj = dict.objectForKey("Local Dictionary");
        if (localObj != null) {
            return new TransferItem(remote, new LocalDictionary(this.deserializer).deserialize(localObj));
        }
        return new TransferItem(remote);
    }
}

