/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer.impl.dd;

import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.serializer.Serializer;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import java.util.List;

public class PlistSerializer
implements Serializer {
    final NSDictionary dict;

    public PlistSerializer() {
        this(new NSDictionary());
    }

    public PlistSerializer(NSDictionary dict) {
        this.dict = dict;
    }

    @Override
    public void setStringForKey(String value, String key) {
        this.dict.put(key, (Object)value);
    }

    @Override
    public void setObjectForKey(Serializable value, String key) {
        this.dict.put(key, (NSObject)value.serialize(SerializerFactory.get()));
    }

    @Override
    public <T extends Serializable> void setListForKey(List<T> value, String key) {
        NSArray list = new NSArray(value.size());
        int i = 0;
        for (Serializable serializable : value) {
            list.setValue(i, serializable.serialize(SerializerFactory.get()));
            ++i;
        }
        this.dict.put(key, (NSObject)list);
    }

    public NSDictionary getSerialized() {
        return this.dict;
    }
}

