/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.openssh;

import ch.cyberduck.core.HostnameConfigurator;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.sftp.openssh.config.transport.OpenSshConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class OpenSSHHostnameConfigurator
implements HostnameConfigurator {
    private static final Logger log = Logger.getLogger(OpenSSHHostnameConfigurator.class);
    private static final Local file = LocalFactory.get("~", ".ssh/config");
    private final OpenSshConfig configuration;

    public OpenSSHHostnameConfigurator() {
        this(new OpenSshConfig(file));
    }

    public OpenSSHHostnameConfigurator(OpenSshConfig configuration) {
        this.configuration = configuration;
    }

    @Override
    public String getHostname(String alias) {
        if (StringUtils.isBlank((CharSequence)alias)) {
            return alias;
        }
        String hostname = this.configuration.lookup(alias).getHostName();
        if (StringUtils.isBlank((CharSequence)hostname)) {
            return alias;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Using hostname alias %s from %s", alias, file));
        }
        return hostname;
    }

    @Override
    public int getPort(String alias) {
        if (StringUtils.isBlank((CharSequence)alias)) {
            return -1;
        }
        return this.configuration.lookup(alias).getPort();
    }

    @Override
    public void reload() {
        this.configuration.refresh();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OpenSSHHostnameConfigurator{");
        sb.append("configuration=").append(this.configuration);
        sb.append('}');
        return sb.toString();
    }
}

