/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import org.apache.log4j.Logger;

public class DefaultAttributesFinderFeature
implements AttributesFinder {
    private static final Logger log = Logger.getLogger(DefaultAttributesFinderFeature.class);
    private final Session<?> session;
    private Cache<Path> cache = PathCache.empty();

    public DefaultAttributesFinderFeature(Session<?> session) {
        this.session = session;
    }

    @Override
    public PathAttributes find(Path file) throws BackgroundException {
        AttributedList<Path> list;
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        if (!this.cache.isCached(file.getParent())) {
            try {
                list = this.session.list(file.getParent(), new DisabledListProgressListener());
                this.cache.put(file.getParent(), list);
            }
            catch (AccessDeniedException | InteroperabilityException | NotfoundException f) {
                log.warn((Object)String.format("Failure listing directory %s. %s", file.getParent(), f.getMessage()));
                AttributesFinder feature = this.session._getFeature(AttributesFinder.class);
                if (feature instanceof DefaultAttributesFinderFeature) {
                    throw f;
                }
                return feature.withCache(this.cache).find(file);
            }
        } else {
            list = this.cache.get(file.getParent());
        }
        Path result = list.find(new SimplePathPredicate(file));
        if (null == result) {
            throw new NotfoundException(file.getAbsolute());
        }
        return result.attributes();
    }

    @Override
    public DefaultAttributesFinderFeature withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

