/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.io.ThrottledInputStream;
import ch.cyberduck.core.io.ThrottledOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import java.io.OutputStream;

public class DefaultCopyFeature
implements Copy {
    private final Session<?> session;

    public DefaultCopyFeature(Session<?> session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void copy(Path source, Path target, TransferStatus status) throws BackgroundException {
        if (source.isDirectory()) {
            if (this.session.getFeature(Find.class).find(target)) return;
            this.session.getFeature(Directory.class).mkdir(target, null, status);
            return;
        }
        if (!this.session.getFeature(Find.class).find(target.getParent())) {
            this.copy(source.getParent(), target.getParent(), new TransferStatus());
        }
        ThrottledInputStream in = null;
        ThrottledOutputStream out = null;
        try {
            in = new ThrottledInputStream(this.session.getFeature(Read.class).read(source, new TransferStatus(), new DisabledConnectionCallback()), new BandwidthThrottle(-1.0f));
            Write write = this.session.getFeature(MultipartWrite.class);
            if (null == write) {
                write = this.session.getFeature(Write.class);
            }
            out = new ThrottledOutputStream((OutputStream)((Object)write.write(target, status, new DisabledConnectionCallback())), new BandwidthThrottle(-1.0f));
            TransferStatus progress = new TransferStatus();
            new StreamCopier(progress, progress).transfer((InputStream)((Object)in), (OutputStream)((Object)out));
        }
        catch (Throwable throwable) {
            new DefaultStreamCloser().close((InputStream)((Object)in));
            new DefaultStreamCloser().close((OutputStream)((Object)out));
            throw throwable;
        }
        new DefaultStreamCloser().close((InputStream)((Object)in));
        new DefaultStreamCloser().close((OutputStream)((Object)out));
    }

    @Override
    public boolean isRecursive(Path source, Path target) {
        return false;
    }

    @Override
    public boolean isSupported(Path source, Path target) {
        switch (this.session.getHost().getProtocol().getType()) {
            case ftp: 
            case irods: {
                return false;
            }
        }
        return true;
    }
}

