/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DefaultFindFeature
implements Find {
    private static final Logger log = Logger.getLogger(DefaultFindFeature.class);
    private final Session<?> session;
    private Cache<Path> cache = PathCache.empty();

    public DefaultFindFeature(Session<?> session) {
        this.session = session;
    }

    @Override
    public boolean find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return true;
        }
        try {
            boolean found;
            AttributedList<Path> list;
            if (!this.cache.isCached(file.getParent())) {
                list = this.session.list(file.getParent(), new DisabledListProgressListener());
                this.cache.put(file.getParent(), list);
            } else {
                list = this.cache.get(file.getParent());
            }
            boolean bl = found = list.find(new SimplePathPredicate(file)) != null;
            if (!found) {
                switch (this.session.getCase()) {
                    case insensitive: {
                        for (Path f : list) {
                            if (!f.getType().equals(file.getType()) || !StringUtils.equalsIgnoreCase((CharSequence)f.getName(), (CharSequence)file.getName())) continue;
                            log.warn((Object)String.format("Found matching file %s ignoring case", f));
                            return true;
                        }
                        break;
                    }
                }
            }
            return found;
        }
        catch (NotfoundException e) {
            return false;
        }
    }

    @Override
    public DefaultFindFeature withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

