/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Search;

public class DefaultSearchFeature
implements Search {
    private final Session<?> session;
    private Cache<Path> cache = PathCache.empty();

    public DefaultSearchFeature(Session<?> session) {
        this.session = session;
    }

    @Override
    public AttributedList<Path> search(Path workdir, Filter<Path> filter, ListProgressListener listener) throws BackgroundException {
        AttributedList<Path> list;
        if (!this.cache.isCached(workdir)) {
            list = this.session.list(workdir, new SearchListProgressListener(filter, listener)).filter(filter);
            this.cache.put(workdir, list);
        } else {
            list = this.cache.get(workdir).filter(filter);
        }
        listener.chunk(workdir, list);
        return list;
    }

    @Override
    public boolean isRecursive() {
        return false;
    }

    @Override
    public Search withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }

    private static final class SearchListProgressListener
    implements ListProgressListener {
        private final Filter<Path> filter;
        private final ListProgressListener delegate;

        public SearchListProgressListener(Filter<Path> filter, ListProgressListener delegate) {
            this.filter = filter;
            this.delegate = delegate;
        }

        @Override
        public void chunk(Path parent, AttributedList<Path> list) throws ConnectionCanceledException {
            this.delegate.chunk(parent, list.filter(this.filter));
        }

        @Override
        public void message(String message) {
            this.delegate.message(message);
        }
    }
}

