/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.CertificateStore;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.ssl.AbstractX509TrustManager;
import ch.cyberduck.core.ssl.TrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class CertificateStoreX509TrustManager
extends AbstractX509TrustManager {
    private static final Logger log = Logger.getLogger(CertificateStoreX509TrustManager.class);
    private final TrustManagerHostnameCallback callback;
    private final CertificateStore store;

    public CertificateStoreX509TrustManager(TrustManagerHostnameCallback callback, CertificateStore store) {
        this.callback = callback;
        this.store = store;
    }

    @Override
    public X509TrustManager init() {
        return this;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String cipher) throws CertificateException {
        this.verify(x509Certificates, cipher);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String cipher) throws CertificateException {
        this.verify(x509Certificates, cipher);
    }

    private void verify(X509Certificate[] certs, String cipher) throws CertificateException {
        this.verify(this.callback.getTarget(), certs, cipher);
    }

    @Override
    public void verify(String hostname, X509Certificate[] certs, String cipher) throws CertificateException {
        if (Arrays.asList(this.getAcceptedIssuers()).containsAll(Arrays.asList(certs))) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Certificate for %s previously trusted", hostname));
            }
            return;
        }
        if (this.store.isTrusted(hostname, Arrays.asList(certs))) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Certificate for %s trusted in Keychain", hostname));
            }
        } else {
            throw new CertificateException(LocaleFactory.localizedString("No trusted certificate found", "Status"));
        }
        this.accept(Arrays.asList(certs));
    }
}

