/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.DefaultSocketExceptionMappingService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.SSLNegotiateException;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class SSLExceptionMappingService
extends AbstractExceptionMappingService<SSLException> {
    private static final Logger log = Logger.getLogger(SSLExceptionMappingService.class);

    @Override
    public BackgroundException map(SSLException failure) {
        StringBuilder buffer = new StringBuilder();
        for (Throwable cause : ExceptionUtils.getThrowableList((Throwable)failure)) {
            if (!(cause instanceof SocketException)) continue;
            return new DefaultSocketExceptionMappingService().map((SocketException)cause);
        }
        String message = failure.getMessage();
        for (Alert alert : Alert.values()) {
            if (!StringUtils.contains((CharSequence)message, (CharSequence)alert.name())) continue;
            this.append(buffer, alert.getDescription());
            break;
        }
        if (failure instanceof SSLHandshakeException) {
            if (ExceptionUtils.getRootCause((Throwable)failure) instanceof CertificateException) {
                log.warn((Object)String.format("Ignore certificate failure %s and drop connection", failure.getMessage()));
                return new ConnectionCanceledException(failure);
            }
            return new SSLNegotiateException(buffer.toString(), failure);
        }
        if (ExceptionUtils.getRootCause((Throwable)failure) instanceof GeneralSecurityException) {
            this.append(buffer, ExceptionUtils.getRootCause((Throwable)failure).getMessage());
            return new InteroperabilityException(buffer.toString(), failure);
        }
        this.append(buffer, message);
        return new InteroperabilityException(buffer.toString(), failure);
    }

    private static enum Alert {
        close_notify(0),
        unexpected_message(10){

            @Override
            public String getDescription() {
                return String.format("%s. An inappropriate message was received.", super.getDescription());
            }
        }
        ,
        bad_record_mac(20){

            @Override
            public String getDescription() {
                return String.format("%s. A record is received with an incorrect MAC.", super.getDescription());
            }
        }
        ,
        decryption_failed_RESERVED(21),
        record_overflow(22),
        decompression_failure(30),
        handshake_failure(40){

            @Override
            public String getDescription() {
                return String.format("%s. Unable to negotiate an acceptable set of security parameters.", super.getDescription());
            }
        }
        ,
        no_certificate_RESERVED(41),
        bad_certificate(42){

            @Override
            public String getDescription() {
                return String.format("%s. The certificate provided could not be verified by the server.", super.getDescription());
            }
        }
        ,
        unsupported_certificate(43){

            @Override
            public String getDescription() {
                return String.format("%s. The certificate type provided is not supported by the server.", super.getDescription());
            }
        }
        ,
        certificate_revoked(44){

            @Override
            public String getDescription() {
                return String.format("%s. The certificate provided has been revoked by its signer.", super.getDescription());
            }
        }
        ,
        certificate_expired(45){

            @Override
            public String getDescription() {
                return String.format("%s. The certificate provided has expired.", super.getDescription());
            }
        }
        ,
        certificate_unknown(46){

            @Override
            public String getDescription() {
                return String.format("%s. The certificate provided was not accepted by the server.", super.getDescription());
            }
        }
        ,
        illegal_parameter(47),
        unknown_ca(48){

            @Override
            public String getDescription() {
                return String.format("%s. A valid certificate chain or partial chain was received, but the certificate was not accepted because the certificate authority certificate could not be located or couldn't be matched with a known, trusted certificate authority.", super.getDescription());
            }
        }
        ,
        access_denied(49){

            @Override
            public String getDescription() {
                return String.format("%s. A valid certificate was received, but when access control was applied, the server decided not to proceed with negotiation.", super.getDescription());
            }
        }
        ,
        decode_error(50),
        decrypt_error(51),
        export_restriction_RESERVED(60),
        protocol_version(70){

            @Override
            public String getDescription() {
                return String.format("%s. The protocol version attempted to negotiate is recognized but not supported.", super.getDescription());
            }
        }
        ,
        insufficient_security(71){

            @Override
            public String getDescription() {
                return String.format("%s. The server requires ciphers more secure than those supported.", super.getDescription());
            }
        }
        ,
        internal_error(80),
        user_canceled(90),
        no_renegotiation(100),
        unsupported_extension(110);

        private final int code;

        private Alert(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return StringUtils.capitalize((String)StringUtils.replaceChars((String)this.name(), (char)'_', (char)' '));
        }
    }
}

