/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.security.Provider;
import java.security.Security;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public abstract class SSLSession<C>
extends Session<C> {
    private static final Logger log = Logger.getLogger(SSLSession.class);
    protected X509TrustManager trust;
    protected X509KeyManager key;

    protected SSLSession(Host h, X509TrustManager trust, X509KeyManager key) {
        super(h);
        this.trust = trust;
        this.key = key;
    }

    @Override
    public <T> T _getFeature(Class<T> type) {
        if (type == X509TrustManager.class) {
            return (T)this.trust;
        }
        if (type == X509KeyManager.class) {
            return (T)this.key;
        }
        return super._getFeature(type);
    }

    static {
        int position = PreferencesFactory.get().getInteger("connection.ssl.provider.bouncycastle.position");
        BouncyCastleProvider provider = new BouncyCastleProvider();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Install provider %s at position %d", provider, position));
        }
        Security.insertProviderAt((Provider)provider, position);
    }
}

