/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.synchronization;

import ch.cyberduck.core.LocalAttributes;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.synchronization.Comparison;
import ch.cyberduck.core.synchronization.ComparisonService;
import org.apache.log4j.Logger;

public class ChecksumComparisonService
implements ComparisonService {
    private static final Logger log = Logger.getLogger(ChecksumComparisonService.class);

    @Override
    public Comparison compare(PathAttributes remote, LocalAttributes local) throws BackgroundException {
        if (Checksum.NONE == remote.getChecksum()) {
            log.warn((Object)String.format("No remote checksum available for comparison %s", remote));
            return Comparison.notequal;
        }
        if (Checksum.NONE == local.getChecksum()) {
            log.warn((Object)String.format("No local checksum available for comparison %s", local));
            return Comparison.notequal;
        }
        if (remote.getChecksum().equals(local.getChecksum())) {
            return Comparison.equal;
        }
        return Comparison.notequal;
    }
}

