/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.threading.ActionOperationBatcher;
import ch.cyberduck.core.threading.ActionOperationBatcherFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.ControllerMainAction;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class BackgroundCallable<T>
implements Callable<T> {
    private static final Logger log = Logger.getLogger(BackgroundCallable.class);
    private final BackgroundAction<T> action;
    private final Controller controller;
    private final BackgroundActionRegistry registry;
    private final Exception client = new Exception();

    public BackgroundCallable(BackgroundAction<T> action, Controller controller, BackgroundActionRegistry registry) {
        this.action = action;
        this.controller = controller;
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() {
        T t;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Running background action %s", this.action));
        }
        ActionOperationBatcher autorelease = ActionOperationBatcherFactory.get();
        if (this.action.isCanceled()) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Prepare background action %s", this.action));
        }
        this.action.prepare();
        try {
            T result = this.run();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Return result %s from background action %s", result, this.action));
            }
            t = result;
        }
        catch (Throwable throwable) {
            try {
                this.action.finish();
            }
            finally {
                this.registry.remove(this.action);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invoke cleanup for background action %s", this.action));
            }
            this.controller.invoke(new ControllerMainAction(this.controller){

                @Override
                public void run() {
                    try {
                        BackgroundCallable.this.action.cleanup();
                    }
                    catch (Exception e) {
                        log.error((Object)String.format("Exception running cleanup task %s", e.getMessage()), (Throwable)e);
                    }
                }
            });
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Releasing lock for background runnable %s", this.action));
            }
            autorelease.operate();
            throw throwable;
        }
        try {
            this.action.finish();
        }
        finally {
            this.registry.remove(this.action);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Invoke cleanup for background action %s", this.action));
        }
        this.controller.invoke(new /* invalid duplicate definition of identical inner class */);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Releasing lock for background runnable %s", this.action));
        }
        autorelease.operate();
        return t;
    }

    protected T run() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Call background action %s", this.action));
            }
            return this.action.call();
        }
        catch (ConnectionCanceledException e) {
            log.warn((Object)String.format("Connection canceled for background task %s", this.action));
            return null;
        }
        catch (BackgroundException e) {
            this.failure(this.client, e);
            if (this.action.alert(e)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Retry background action %s", this.action));
                }
                return this.run();
            }
            return null;
        }
        catch (Exception e) {
            this.failure(this.client, e);
            return null;
        }
    }

    protected void failure(Exception trace, Exception failure) {
        try {
            trace.initCause(failure);
        }
        catch (IllegalStateException e) {
            log.warn((Object)String.format("Failure overwriting cause for failure %s with %s", trace, failure));
        }
        log.warn((Object)String.format("Failure running background task %s", failure.getMessage()), (Throwable)trace);
    }
}

