/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Download;
import ch.cyberduck.core.filter.DownloadDuplicateFilter;
import ch.cyberduck.core.filter.DownloadRegexFilter;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.local.LocalSymlinkFactory;
import ch.cyberduck.core.local.features.Symlink;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.download.AbstractDownloadFilter;
import ch.cyberduck.core.transfer.download.CompareFilter;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.core.transfer.download.DownloadRegexPriorityComparator;
import ch.cyberduck.core.transfer.download.IconUpdateSreamListener;
import ch.cyberduck.core.transfer.download.OverwriteFilter;
import ch.cyberduck.core.transfer.download.RenameExistingFilter;
import ch.cyberduck.core.transfer.download.RenameFilter;
import ch.cyberduck.core.transfer.download.ResumeFilter;
import ch.cyberduck.core.transfer.download.SkipFilter;
import ch.cyberduck.core.transfer.download.TrashFilter;
import ch.cyberduck.core.transfer.normalizer.DownloadRootPathsNormalizer;
import ch.cyberduck.core.transfer.symlink.DownloadSymlinkResolver;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DownloadTransfer
extends Transfer {
    private static final Logger log = Logger.getLogger(DownloadTransfer.class);
    private final Filter<Path> filter;
    private final Comparator<Path> comparator;
    private PathCache cache = new PathCache(PreferencesFactory.get().getInteger("transfer.cache.size"));
    private final DownloadSymlinkResolver symlinkResolver;
    private DownloadFilterOptions options = new DownloadFilterOptions();

    public DownloadTransfer(Host host, Path root, Local local) {
        this(host, Collections.singletonList(new TransferItem(root, local)), PreferencesFactory.get().getBoolean("queue.download.skip.enable") ? new DownloadRegexFilter() : new DownloadDuplicateFilter());
    }

    public DownloadTransfer(Host host, Path root, Local local, Filter<Path> f) {
        this(host, Collections.singletonList(new TransferItem(root, local)), f);
    }

    public DownloadTransfer(Host host, List<TransferItem> roots) {
        this(host, new DownloadRootPathsNormalizer().normalize(roots), PreferencesFactory.get().getBoolean("queue.download.skip.enable") ? new DownloadRegexFilter() : new DownloadDuplicateFilter());
    }

    public DownloadTransfer(Host host, List<TransferItem> roots, Filter<Path> f) {
        this(host, roots, f, new DownloadRegexPriorityComparator());
    }

    public DownloadTransfer(Host host, List<TransferItem> roots, Filter<Path> f, Comparator<Path> comparator) {
        super(host, new DownloadRootPathsNormalizer().normalize(roots), new BandwidthThrottle(PreferencesFactory.get().getFloat("queue.download.bandwidth.bytes")));
        this.filter = f;
        this.comparator = comparator;
        this.symlinkResolver = new DownloadSymlinkResolver(roots);
    }

    @Override
    public DownloadTransfer withCache(PathCache cache) {
        this.cache = cache;
        return this;
    }

    public Transfer withOptions(DownloadFilterOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public Transfer.Type getType() {
        return Transfer.Type.download;
    }

    @Override
    public List<TransferItem> list(Session<?> source, Session<?> destination, Path directory, Local local, ListProgressListener listener) throws BackgroundException {
        AttributedList<Path> list;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("List children for %s", directory));
        }
        if (directory.isSymbolicLink() && new DownloadSymlinkResolver(this.roots).resolve(directory)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Do not list children for symbolic link %s", directory));
            }
            return Collections.emptyList();
        }
        if (this.cache.containsKey(directory)) {
            list = this.cache.get(directory);
        } else {
            list = source.getFeature(ListService.class).list(directory, listener);
            this.cache.put(directory, list);
        }
        ArrayList<TransferItem> children = new ArrayList<TransferItem>();
        for (Path f : new AttributedList<Path>(list.filter(this.comparator, this.filter))) {
            children.add(new TransferItem(f, LocalFactory.get(local, f.getName())));
        }
        return children;
    }

    @Override
    public AbstractDownloadFilter filter(Session<?> source, Session<?> destination, TransferAction action, ProgressListener listener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Filter transfer with action %s", action));
        }
        DownloadSymlinkResolver resolver = new DownloadSymlinkResolver(this.roots);
        if (action.equals(TransferAction.resume)) {
            return new ResumeFilter(resolver, source, this.options).withCache(this.cache);
        }
        if (action.equals(TransferAction.rename)) {
            return new RenameFilter(resolver, source, this.options).withCache(this.cache);
        }
        if (action.equals(TransferAction.renameexisting)) {
            return new RenameExistingFilter(resolver, source, this.options).withCache(this.cache);
        }
        if (action.equals(TransferAction.skip)) {
            return new SkipFilter(resolver, source, this.options).withCache(this.cache);
        }
        if (action.equals(TransferAction.trash)) {
            return new TrashFilter(resolver, source, this.options).withCache(this.cache);
        }
        if (action.equals(TransferAction.comparison)) {
            return new CompareFilter((SymlinkResolver<Path>)resolver, source, this.options, listener).withCache(this.cache);
        }
        return new OverwriteFilter(resolver, source, this.options).withCache(this.cache);
    }

    @Override
    public TransferAction action(Session<?> source, Session<?> destination, boolean resumeRequested, boolean reloadRequested, TransferPrompt prompt, ListProgressListener listener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Find transfer action for Resume=%s,Reload=%s", resumeRequested, reloadRequested));
        }
        if (resumeRequested) {
            return TransferAction.resume;
        }
        TransferAction action = reloadRequested ? TransferAction.forName(PreferencesFactory.get().getProperty("queue.download.reload.action")) : TransferAction.forName(PreferencesFactory.get().getProperty("queue.download.action"));
        if (action.equals(TransferAction.callback)) {
            for (TransferItem download : this.roots) {
                Local local = download.local;
                if (!local.exists() || local.isDirectory() && local.list().isEmpty() || local.isFile() && local.attributes().getSize() == 0L) continue;
                return prompt.prompt(download);
            }
            return TransferAction.overwrite;
        }
        return action;
    }

    @Override
    public void pre(Session<?> source, Session<?> destination, Map<Path, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        Bulk feature = source.getFeature(Bulk.class);
        Object id = feature.pre(Transfer.Type.download, files, callback);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Obtained bulk id %s for transfer %s", id, this));
        }
    }

    @Override
    public void post(Session<?> source, Session<?> destination, Map<Path, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        Bulk feature = source.getFeature(Bulk.class);
        feature.post(Transfer.Type.download, files, callback);
    }

    @Override
    public void transfer(Session<?> source, Session<?> destination, Path file, Local local, TransferOptions options, TransferStatus status, ConnectionCallback callback, ProgressListener listener, StreamListener streamListener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Transfer file %s with options %s", file, options));
        }
        if (file.isSymbolicLink() && this.symlinkResolver.resolve(file)) {
            String target = this.symlinkResolver.relativize(file.getAbsolute(), file.getSymlinkTarget().getAbsolute());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Create symbolic link from %s to %s", local, target));
            }
            Symlink symlink = LocalSymlinkFactory.get();
            symlink.symlink(local, target);
            return;
        }
        if (file.isFile()) {
            listener.message(MessageFormat.format(LocaleFactory.localizedString("Downloading {0}", "Status"), file.getName()));
            Local folder = local.getParent();
            if (!folder.exists()) {
                folder.mkdir();
            }
            Download download = source.getFeature(Download.class);
            download.download(file, local, this.bandwidth, new IconUpdateSreamListener(streamListener, status, local){

                @Override
                public void recv(long bytes) {
                    DownloadTransfer.this.addTransferred(bytes);
                    super.recv(bytes);
                }
            }, status, callback);
        } else if (file.isDirectory() && !status.isExists()) {
            listener.message(MessageFormat.format(LocaleFactory.localizedString("Making directory {0}", "Status"), local.getName()));
            local.mkdir();
            status.setComplete();
        }
    }
}

