/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.upload;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.synchronization.Comparison;
import ch.cyberduck.core.synchronization.ComparisonServiceFilter;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import ch.cyberduck.core.transfer.upload.AbstractUploadFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import org.apache.log4j.Logger;

public class CompareFilter
extends AbstractUploadFilter {
    private static final Logger log = Logger.getLogger(CompareFilter.class);
    private final ComparisonServiceFilter comparisonService;

    public CompareFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session, ProgressListener listener) {
        this(symlinkResolver, session, new UploadFilterOptions(), new ComparisonServiceFilter(session, session.getHost().getTimezone(), listener));
    }

    public CompareFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session, UploadFilterOptions options, ProgressListener listener) {
        super(symlinkResolver, session, options);
        this.comparisonService = new ComparisonServiceFilter(session, session.getHost().getTimezone(), listener);
    }

    public CompareFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session, UploadFilterOptions options, ComparisonServiceFilter comparisonService) {
        super(symlinkResolver, session, options);
        this.comparisonService = comparisonService;
    }

    @Override
    public AbstractUploadFilter withCache(PathCache cache) {
        this.comparisonService.withCache(cache);
        return super.withCache(cache);
    }

    @Override
    public boolean accept(Path file, Local local, TransferStatus parent) throws BackgroundException {
        if (super.accept(file, local, parent)) {
            Comparison comparison = this.comparisonService.compare(file, local);
            switch (comparison) {
                case local: {
                    return true;
                }
                case equal: {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Skip file %s with comparison %s", new Object[]{file, comparison}));
                    }
                    return false;
                }
                case remote: {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Skip file %s with comparison %s", new Object[]{file, comparison}));
                    }
                    return false;
                }
            }
            log.warn((Object)String.format("Invalid comparison result %s", new Object[]{comparison}));
        }
        return false;
    }
}

