/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.upload;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import ch.cyberduck.core.transfer.upload.AbstractUploadFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import org.apache.log4j.Logger;

public class ResumeFilter
extends AbstractUploadFilter {
    private static final Logger log = Logger.getLogger(ResumeFilter.class);
    private final Upload upload;
    private PathCache cache = PathCache.empty();

    public ResumeFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session) {
        this(symlinkResolver, session, new UploadFilterOptions());
    }

    public ResumeFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session, UploadFilterOptions options) {
        this(symlinkResolver, session, options, session.getFeature(Upload.class));
    }

    public ResumeFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session, UploadFilterOptions options, Upload upload) {
        super(symlinkResolver, session, options);
        this.upload = upload;
    }

    @Override
    public AbstractUploadFilter withCache(PathCache cache) {
        this.cache = cache;
        return super.withCache(cache);
    }

    @Override
    public boolean accept(Path file, Local local, TransferStatus parent) throws BackgroundException {
        if (super.accept(file, local, parent)) {
            if (local.isFile() && parent.isExists()) {
                Write.Append append = this.upload.append(file, local.attributes().getSize(), this.cache);
                if (append.size.longValue() == local.attributes().getSize()) {
                    if (Checksum.NONE != append.checksum) {
                        ChecksumCompute compute = ChecksumComputeFactory.get(append.checksum.algorithm);
                        if (compute.compute(local.getInputStream(), parent).equals(append.checksum)) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)String.format("Skip file %s with checksum %s", file, local.attributes().getChecksum()));
                            }
                            return false;
                        }
                        log.warn((Object)String.format("Checksum mismatch for %s and %s", file, local));
                    } else {
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("Skip file %s with remote size %d", file, append.size));
                        }
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public TransferStatus prepare(Path file, Local local, TransferStatus parent) throws BackgroundException {
        TransferStatus status = super.prepare(file, local, parent);
        if (local.isFile() && parent.isExists()) {
            Write.Append append = this.upload.append(file, status.getLength(), this.cache);
            if (append.append && append.size < local.attributes().getSize()) {
                status.setAppend(true);
                status.setLength(status.getLength() - append.size);
                status.setOffset(append.size);
                status.rename((Path)null);
            }
        }
        return status;
    }
}

