/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.updater;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.SingleThreadController;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.updater.DisabledPeriodicUpdater;
import ch.cyberduck.core.updater.PeriodicUpdateChecker;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class PeriodicUpdateCheckerFactory
extends Factory<PeriodicUpdateChecker> {
    private static final Logger log = Logger.getLogger(PeriodicUpdateCheckerFactory.class);

    public PeriodicUpdateCheckerFactory() {
        super("factory.updater.class");
    }

    public PeriodicUpdateChecker create(Controller controller) {
        String clazz = PreferencesFactory.get().getProperty("factory.updater.class");
        if (null == clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", this.getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{controller.getClass()});
            if (null == constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", controller.getClass()));
                return (PeriodicUpdateChecker)name.newInstance();
            }
            return (PeriodicUpdateChecker)constructor.newInstance(controller);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error((Object)String.format("Failure loading callback class %s. %s", clazz, e.getMessage()));
            return new DisabledPeriodicUpdater();
        }
    }

    public static PeriodicUpdateChecker get() {
        return PeriodicUpdateCheckerFactory.get(new SingleThreadController());
    }

    public static PeriodicUpdateChecker get(Controller controller) {
        return new PeriodicUpdateCheckerFactory().create(controller);
    }
}

