/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.vault.VaultLookupListener;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.vault.VaultUnlockCancelException;
import org.apache.log4j.Logger;

public class LoadingVaultLookupListener
implements VaultLookupListener {
    private static final Logger log = Logger.getLogger(LoadingVaultLookupListener.class);
    private final Session<?> session;
    private final VaultRegistry registry;
    private final PasswordCallback prompt;

    public LoadingVaultLookupListener(Session<?> session, VaultRegistry registry, PasswordCallback prompt) {
        this.session = session;
        this.registry = registry;
        this.prompt = prompt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void found(Vault vault) throws VaultUnlockCancelException {
        VaultRegistry vaultRegistry = this.registry;
        synchronized (vaultRegistry) {
            if (this.registry.contains(vault)) {
                log.warn((Object)String.format("Ignore vault %s found already loaded", vault));
                return;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Loading vault %s for session %s", vault, this.session));
            }
            try {
                this.registry.found(vault.load(this.session, this.prompt));
            }
            catch (BackgroundException e) {
                log.warn((Object)String.format("Failure loading vault %s. %s", vault, e.getDetail()));
                throw new VaultUnlockCancelException(vault);
            }
        }
    }
}

