/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class VaultFactory
extends Factory<Vault> {
    private static final Logger log = Logger.getLogger(VaultFactory.class);

    protected VaultFactory() {
        super("factory.vault.class");
    }

    public static Vault get(Path directory, PasswordStore keychain) {
        return new VaultFactory().create(directory, keychain);
    }

    private Vault create(Path directory, PasswordStore keychain) {
        String clazz = PreferencesFactory.get().getProperty("factory.vault.class");
        if (null == clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", this.getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{directory.getClass(), keychain.getClass()});
            if (null == constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", directory.getClass()));
                return (Vault)name.newInstance();
            }
            return (Vault)constructor.newInstance(directory, keychain);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error((Object)String.format("Failure loading callback class %s. %s", clazz, e.getMessage()));
            return Vault.DISABLED;
        }
    }
}

