/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.IndexedListProgressListener;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.vault.VaultFactory;
import ch.cyberduck.core.vault.VaultFoundListCanceledException;
import ch.cyberduck.core.vault.VaultLookupListener;
import ch.cyberduck.core.vault.VaultUnlockCancelException;
import org.apache.log4j.Logger;

public class VaultFinderListProgressListener
extends IndexedListProgressListener {
    private static final Logger log = Logger.getLogger(VaultFinderListProgressListener.class);
    private static final String MASTERKEY_FILE_NAME = "masterkey.cryptomator";
    private final PasswordStore keychain;
    private final VaultLookupListener listener;

    public VaultFinderListProgressListener(PasswordStore keychain, VaultLookupListener listener) {
        this.keychain = keychain;
        this.listener = listener;
    }

    @Override
    public void message(String message) {
    }

    @Override
    public void visit(AttributedList<Path> list, int index, Path file) throws ConnectionCanceledException {
        Path directory = file.getParent();
        if (MASTERKEY_FILE_NAME.equals(file.getName())) {
            Vault vault;
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Found master key %s", file));
            }
            if ((vault = VaultFactory.get(directory, this.keychain)).equals(Vault.DISABLED)) {
                return;
            }
            try {
                this.listener.found(vault);
            }
            catch (VaultUnlockCancelException e) {
                return;
            }
            throw new VaultFoundListCanceledException(vault, list);
        }
    }
}

