/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.DefaultVaultRegistry;
import ch.cyberduck.core.vault.VaultUnlockCancelException;

public class VaultRegistryCopyFeature
implements Copy {
    private final Session<?> session;
    private final Copy proxy;
    private final DefaultVaultRegistry registry;

    public VaultRegistryCopyFeature(Session<?> session, Copy proxy, DefaultVaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public void copy(Path source, Path target, TransferStatus status) throws BackgroundException {
        if (this.registry.find(this.session, source).equals(Vault.DISABLED)) {
            this.registry.find(this.session, target).getFeature(this.session, Copy.class, this.proxy).copy(source, target, status);
        } else if (this.registry.find(this.session, target).equals(Vault.DISABLED)) {
            this.registry.find(this.session, source).getFeature(this.session, Copy.class, this.proxy).copy(source, target, status);
        } else {
            this.proxy.copy(source, target, status);
        }
    }

    @Override
    public boolean isRecursive(Path source, Path target) {
        try {
            if (this.registry.find(this.session, source, false).equals(Vault.DISABLED)) {
                return this.registry.find(this.session, target, false).getFeature(this.session, Copy.class, this.proxy).isRecursive(source, target);
            }
            if (this.registry.find(this.session, target, false).equals(Vault.DISABLED)) {
                return this.registry.find(this.session, source, false).getFeature(this.session, Copy.class, this.proxy).isRecursive(source, target);
            }
        }
        catch (VaultUnlockCancelException vaultUnlockCancelException) {
            // empty catch block
        }
        return this.proxy.isRecursive(source, target);
    }

    @Override
    public boolean isSupported(Path source, Path target) {
        try {
            if (this.registry.find(this.session, source, false).equals(Vault.DISABLED)) {
                return this.registry.find(this.session, target, false).getFeature(this.session, Copy.class, this.proxy).isSupported(source, target);
            }
            if (this.registry.find(this.session, target, false).equals(Vault.DISABLED)) {
                return this.registry.find(this.session, source, false).getFeature(this.session, Copy.class, this.proxy).isSupported(source, target);
            }
        }
        catch (VaultUnlockCancelException vaultUnlockCancelException) {
            // empty catch block
        }
        return this.proxy.isSupported(source, target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryCopyFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

