/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.vault.VaultRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VaultRegistryDeleteFeature
implements Delete {
    private final Session<?> session;
    private final Delete proxy;
    private final VaultRegistry registry;

    public VaultRegistryDeleteFeature(Session<?> session, Delete proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public void delete(List<Path> files, LoginCallback prompt, Delete.Callback callback) throws BackgroundException {
        Vault vault;
        HashMap vaults = new HashMap();
        for (Path path : files) {
            vault = this.registry.find(this.session, path);
            List sorted = vaults.containsKey(vault) ? (List)vaults.get(vault) : new ArrayList();
            sorted.add(path);
            vaults.put(vault, sorted);
        }
        for (Map.Entry entry : vaults.entrySet()) {
            vault = (Vault)entry.getKey();
            Delete feature = vault.getFeature(this.session, Delete.class, this.proxy);
            feature.delete((List)entry.getValue(), prompt, callback);
        }
    }

    @Override
    public boolean isSupported(Path file) {
        return this.proxy.isSupported(file);
    }

    @Override
    public boolean isRecursive() {
        return this.proxy.isRecursive();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryDeleteFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

