/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.vault.VaultRegistry;

public class VaultRegistryFindFeature
implements Find {
    private final Session<?> session;
    private final Find proxy;
    private final VaultRegistry registry;
    private Cache<Path> cache = PathCache.empty();

    public VaultRegistryFindFeature(Session<?> session, Find proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public boolean find(Path file) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Find.class, this.proxy).withCache(this.cache).find(file);
    }

    @Override
    public Find withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryFindFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

