/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.vault.VaultRegistry;

public class VaultRegistryIdProvider
implements IdProvider {
    private final Session<?> session;
    private final IdProvider proxy;
    private final VaultRegistry registry;

    public VaultRegistryIdProvider(Session<?> session, IdProvider proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public String getFileid(Path file) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, IdProvider.class, this.proxy).getFileid(file);
    }

    @Override
    public IdProvider withCache(Cache<Path> cache) {
        this.proxy.withCache(cache);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryIdProvider{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

