/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.DefaultVaultRegistry;
import ch.cyberduck.core.vault.VaultUnlockCancelException;
import java.util.Collections;
import org.apache.log4j.Logger;

public class VaultRegistryMoveFeature
implements Move {
    private static final Logger log = Logger.getLogger(VaultRegistryMoveFeature.class);
    private final Session<?> session;
    private final Move proxy;
    private final DefaultVaultRegistry registry;

    public VaultRegistryMoveFeature(Session<?> session, Move proxy, DefaultVaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public void move(Path source, Path target, boolean exists, Delete.Callback callback) throws BackgroundException {
        if (this.registry.find(this.session, source).equals(this.registry.find(this.session, target))) {
            Vault vault = this.registry.find(this.session, source);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Move %s to %s inside vault %s", source, target, vault));
            }
            vault.getFeature(this.session, Move.class, this.proxy).move(source, target, exists, callback);
        } else {
            Copy copy = this.session.getFeature(Copy.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Move %s to %s using copy feature %s", source, target, copy));
            }
            copy.copy(source, target, new TransferStatus());
            this.session.getFeature(Delete.class).delete(Collections.singletonList(source), new DisabledLoginCallback(), callback);
        }
    }

    @Override
    public boolean isRecursive(Path source, Path target) {
        try {
            if (this.registry.find(this.session, source, false).equals(this.registry.find(this.session, target, false))) {
                return this.registry.find(this.session, source, false).getFeature(this.session, Move.class, this.proxy).isRecursive(source, target);
            }
            return this.session.getFeature(Copy.class).isRecursive(source, target);
        }
        catch (VaultUnlockCancelException e) {
            return this.proxy.isRecursive(source, target);
        }
    }

    @Override
    public boolean isSupported(Path source, Path target) {
        try {
            if (this.registry.find(this.session, source, false).equals(this.registry.find(this.session, target, false))) {
                return this.registry.find(this.session, source, false).getFeature(this.session, Move.class, this.proxy).isSupported(source, target);
            }
            return this.session.getFeature(Copy.class).isSupported(source, target);
        }
        catch (VaultUnlockCancelException e) {
            return false;
        }
    }

    @Override
    public Move withDelete(Delete delete) {
        this.proxy.withDelete(delete);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryMoveFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

