/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.VaultRegistry;
import java.io.InputStream;

public class VaultRegistryReadFeature
implements Read {
    private final Session<?> session;
    private final Read proxy;
    private final VaultRegistry registry;

    public VaultRegistryReadFeature(Session<?> session, Read proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Read.class, this.proxy).read(file, status, callback);
    }

    @Override
    public boolean offset(Path file) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Read.class, this.proxy).offset(file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryReadFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

