/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.DefaultVaultRegistry;
import ch.cyberduck.core.vault.VaultUnlockCancelException;

public class VaultRegistryTouchFeature<R>
implements Touch<R> {
    private final Session<?> session;
    private final Touch<R> proxy;
    private final DefaultVaultRegistry registry;

    public VaultRegistryTouchFeature(Session<?> session, Touch<R> proxy, DefaultVaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Touch.class, this.proxy).touch(file, status);
    }

    @Override
    public boolean isSupported(Path workdir) {
        try {
            return this.registry.find(this.session, workdir, false).getFeature(this.session, Touch.class, this.proxy).isSupported(workdir);
        }
        catch (VaultUnlockCancelException e) {
            return false;
        }
    }

    @Override
    public Touch<R> withWriter(Write<R> writer) {
        this.proxy.withWriter(writer);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryTouchFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

