/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.worker.ActionListProgressListener;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DeleteWorker
extends Worker<List<Path>> {
    private final Cache<Path> cache;
    private final List<Path> files;
    private final LoginCallback prompt;
    private final ProgressListener listener;
    private final Filter<Path> filter;

    public DeleteWorker(LoginCallback prompt, List<Path> files, Cache<Path> cache, ProgressListener listener) {
        this(prompt, files, cache, new NullFilter<Path>(), listener);
    }

    public DeleteWorker(LoginCallback prompt, List<Path> files, Cache<Path> cache, Filter<Path> filter, ProgressListener listener) {
        this.files = files;
        this.prompt = prompt;
        this.listener = listener;
        this.filter = filter;
        this.cache = cache;
    }

    @Override
    public List<Path> run(Session<?> session) throws BackgroundException {
        Delete feature = session.getFeature(Delete.class);
        ArrayList<Path> recursive = new ArrayList<Path>();
        for (Path file : this.files) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            if (!feature.isSupported(file)) {
                throw new UnsupportedException();
            }
            recursive.addAll(this.compile(session.getFeature(Delete.class), session.getFeature(ListService.class), file));
        }
        feature.delete(recursive, this.prompt, new Delete.Callback(){

            @Override
            public void delete(Path file) {
                DeleteWorker.this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Deleting {0}", "Status"), file.getName()));
            }
        });
        return recursive;
    }

    protected List<Path> compile(Delete delete, ListService list, Path file) throws BackgroundException {
        ArrayList<Path> recursive = new ArrayList<Path>();
        if (file.isFile() || file.isSymbolicLink()) {
            recursive.add(file);
        } else if (file.isDirectory()) {
            if (!delete.isRecursive()) {
                for (Path child : list.list(file, new ActionListProgressListener(this, this.listener)).filter(this.filter)) {
                    if (this.isCanceled()) {
                        throw new ConnectionCanceledException();
                    }
                    recursive.addAll(this.compile(delete, list, child));
                }
            }
            recursive.add(file);
        }
        return recursive;
    }

    @Override
    public void cleanup(List<Path> deleted) {
        for (Path f : deleted) {
            if (!f.isDirectory()) continue;
            this.cache.remove(f);
        }
        super.cleanup(deleted);
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Deleting {0}", "Status"), this.toString(this.files));
    }

    @Override
    public List<Path> initialize() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteWorker)) {
            return false;
        }
        DeleteWorker that = (DeleteWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return Objects.hash(this.files);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DeleteWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

