/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.worker.ActionListProgressListener;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MoveWorker
extends Worker<List<Path>> {
    private final Map<Path, Path> files;
    private final ProgressListener listener;
    private final Cache<Path> cache;

    public MoveWorker(Map<Path, Path> files, ProgressListener listener, Cache<Path> cache) {
        this.files = files;
        this.listener = listener;
        this.cache = cache;
    }

    @Override
    public List<Path> run(Session<?> session) throws BackgroundException {
        Move move = session.getFeature(Move.class);
        for (Map.Entry<Path, Path> entry : this.files.entrySet()) {
            Path target;
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            Path source = entry.getKey();
            if (!move.isSupported(source, target = entry.getValue())) {
                throw new UnsupportedException();
            }
            boolean exists = this.cache.isCached(target.getParent()) ? this.cache.get(target.getParent()).contains(target) : false;
            Map<Path, Path> recursive = this.compile(move, session.getFeature(ListService.class), source, target);
            for (Map.Entry<Path, Path> r : recursive.entrySet()) {
                move.move(r.getKey(), r.getValue(), exists, new Delete.Callback(){

                    @Override
                    public void delete(Path file) {
                        MoveWorker.this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Deleting {0}", "Status"), file.getName()));
                    }
                });
            }
        }
        ArrayList<Path> changed = new ArrayList<Path>();
        changed.addAll(this.files.keySet());
        changed.addAll(this.files.values());
        return changed;
    }

    protected Map<Path, Path> compile(Move move, ListService list, Path source, Path target) throws BackgroundException {
        LinkedHashMap<Path, Path> recursive = new LinkedHashMap<Path, Path>();
        if (source.isFile() || source.isSymbolicLink()) {
            recursive.put(source, target);
        } else if (source.isDirectory()) {
            if (!move.isRecursive(source, target)) {
                for (Path child : list.list(source, new ActionListProgressListener(this, this.listener))) {
                    if (this.isCanceled()) {
                        throw new ConnectionCanceledException();
                    }
                    recursive.putAll(this.compile(move, list, child, new Path(target, child.getName(), child.getType())));
                }
            }
            recursive.put(source, target);
        }
        return recursive;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Renaming {0} to {1}", "Status"), this.files.keySet().iterator().next().getName(), this.files.values().iterator().next().getName());
    }

    @Override
    public List<Path> initialize() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MoveWorker that = (MoveWorker)o;
        return !(this.files != null ? !this.files.equals(that.files) : that.files != null);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MoveWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

