/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class ReadMetadataWorker
extends Worker<Map<String, String>> {
    private final List<Path> files;

    public ReadMetadataWorker(List<Path> files) {
        this.files = files;
    }

    @Override
    public Map<String, String> run(Session<?> session) throws BackgroundException {
        Headers feature = session.getFeature(Headers.class);
        HashMap<Path, HashMap<String, String>> fullMetadata = new HashMap<Path, HashMap<String, String>>();
        HashMap graphMetadata = new HashMap();
        for (Path file : this.files) {
            Map<String, String> metadata = feature.getMetadata(file);
            file.attributes().setMetadata(metadata);
            fullMetadata.put(file, new HashMap<String, String>(metadata));
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                if (graphMetadata.containsKey(entry.getKey())) {
                    ((Map)graphMetadata.get(entry.getKey())).put(file, entry.getValue());
                    continue;
                }
                HashMap<Path, String> map = new HashMap<Path, String>();
                graphMetadata.put(entry.getKey(), map);
                map.put(file, entry.getValue());
            }
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (Map.Entry entry : graphMetadata.entrySet()) {
            if (((Map)entry.getValue()).size() != this.files.size()) {
                metadata.put((String)entry.getKey(), (String)null);
                continue;
            }
            Supplier<Stream> valueSupplier = () -> ((Map)entry.getValue()).entrySet().stream().map(y -> (String)y.getValue()).distinct();
            String value = valueSupplier.get().count() == 1L ? (String)valueSupplier.get().findAny().get() : null;
            metadata.put((String)entry.getKey(), value);
        }
        return metadata;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Reading metadata of {0}", "Status"), this.toString(this.files));
    }

    @Override
    public Map<String, String> initialize() {
        return Collections.emptyMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadMetadataWorker that = (ReadMetadataWorker)o;
        return !(this.files != null ? !this.files.equals(that.files) : that.files != null);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReadMetadataWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

