/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.worker.ActionListProgressListener;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Pattern;

public class SearchWorker
extends Worker<AttributedList<Path>> {
    private final Path directory;
    private final Filter<Path> filter;
    private final PathCache cache;
    private final ListProgressListener listener;

    public SearchWorker(Path directory, Filter<Path> filter, PathCache cache, ListProgressListener listener) {
        this.directory = directory;
        this.filter = filter;
        this.cache = cache;
        this.listener = listener;
    }

    @Override
    public AttributedList<Path> run(Session<?> session) throws BackgroundException {
        Search search = session.getFeature(Search.class);
        search.withCache(this.cache);
        return this.search(search, this.directory);
    }

    private AttributedList<Path> search(Search search, Path workdir) throws BackgroundException {
        if (this.isCanceled()) {
            throw new ConnectionCanceledException();
        }
        AttributedList<Path> list = search.search(workdir, new RecursiveSearchFilter(), new ActionListProgressListener(this, this.listener));
        if (!search.isRecursive()) {
            Iterator<Path> iter = list.iterator();
            while (iter.hasNext()) {
                Path file = iter.next();
                if (!file.isDirectory() || !this.search(search, file).isEmpty() || !list.attributes().addHidden(file)) continue;
                iter.remove();
            }
        }
        return list;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Searching in {0}", "Status"), this.directory.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchWorker)) {
            return false;
        }
        SearchWorker that = (SearchWorker)o;
        return Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.filter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SearchWorker{");
        sb.append("filter='").append(this.filter).append('\'');
        sb.append('}');
        return sb.toString();
    }

    private final class RecursiveSearchFilter
    implements Filter<Path> {
        private RecursiveSearchFilter() {
        }

        @Override
        public boolean accept(Path file) {
            if (file.isDirectory()) {
                return true;
            }
            return SearchWorker.this.filter.accept(file);
        }

        @Override
        public Pattern toPattern() {
            return SearchWorker.this.filter.toPattern();
        }

        public int hashCode() {
            return SearchWorker.this.filter.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Filter) {
                return SearchWorker.this.filter.equals(obj);
            }
            return false;
        }
    }
}

