/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.ListCanceledException;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class SessionListWorker
extends Worker<AttributedList<Path>>
implements ListProgressListener {
    private static final Logger log = Logger.getLogger(SessionListWorker.class);
    private final Cache<Path> cache;
    private final Path directory;
    private final ListProgressListener listener;

    public SessionListWorker(Cache<Path> cache, Path directory, ListProgressListener listener) {
        this.cache = cache;
        this.directory = directory;
        this.listener = listener;
    }

    @Override
    public AttributedList<Path> run(Session<?> session) throws BackgroundException {
        try {
            if (this.isCached()) {
                AttributedList<Path> list = this.cache.get(this.directory);
                this.chunk(this.directory, list);
                return list;
            }
            return session.getFeature(ListService.class).list(this.directory, this.listener);
        }
        catch (ListCanceledException e) {
            return e.getChunk();
        }
    }

    protected boolean isCached() {
        return this.cache.isValid(this.directory);
    }

    @Override
    public void cleanup(AttributedList<Path> list) {
        if (AttributedList.emptyList() != list) {
            this.cache.put(this.directory, list);
        }
    }

    @Override
    public void chunk(Path parent, AttributedList<Path> list) throws ConnectionCanceledException {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Retrieved chunk of %d items in %s", list.size(), this.directory));
        }
        if (this.isCanceled()) {
            throw new ConnectionCanceledException();
        }
        this.listener.chunk(this.directory, list);
    }

    @Override
    public void message(String message) {
        this.listener.message(message);
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Listing directory {0}", "Status"), this.directory.getName());
    }

    @Override
    public AttributedList<Path> initialize() {
        return AttributedList.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionListWorker that = (SessionListWorker)o;
        return !(this.directory != null ? !this.directory.equals(that.directory) : that.directory != null);
    }

    public int hashCode() {
        return this.directory != null ? this.directory.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SessionListWorker{");
        sb.append("directory=").append(this.directory);
        sb.append('}');
        return sb.toString();
    }
}

