/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferSpeedometer;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.AbstractTransferWorker;
import ch.cyberduck.core.worker.TransferWorker;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;

public class SingleTransferWorker
extends AbstractTransferWorker {
    private final Session source;
    private final Session destination;

    public SingleTransferWorker(Session source, Session destination, Transfer transfer, TransferOptions options, TransferSpeedometer meter, TransferPrompt prompt, TransferErrorCallback error, ProgressListener listener, StreamListener streamListener, ConnectionCallback connectionCallback) {
        super(transfer, options, prompt, meter, error, listener, streamListener, connectionCallback);
        this.source = source;
        this.destination = destination;
    }

    public SingleTransferWorker(Session source, Session destination, Transfer transfer, TransferOptions options, TransferSpeedometer meter, TransferPrompt prompt, TransferErrorCallback error, ProgressListener listener, StreamListener streamListener, ConnectionCallback connectionCallback, Cache<TransferItem> cache) {
        super(transfer, options, prompt, meter, error, listener, streamListener, connectionCallback, cache);
        this.source = source;
        this.destination = destination;
    }

    public SingleTransferWorker(Session source, Session destination, Transfer transfer, TransferOptions options, TransferSpeedometer meter, TransferPrompt prompt, TransferErrorCallback error, ProgressListener progress, StreamListener stream, ConnectionCallback connectionCallback, Cache<TransferItem> cache, Map<Path, TransferStatus> table) {
        super(transfer, options, prompt, meter, error, progress, stream, connectionCallback, cache, table);
        this.source = source;
        this.destination = destination;
    }

    public Session borrow(AbstractTransferWorker.Connection type) {
        switch (type) {
            case source: {
                return this.source;
            }
            case destination: {
                return this.destination;
            }
        }
        return null;
    }

    @Override
    protected void release(Session session, AbstractTransferWorker.Connection type) throws BackgroundException {
    }

    @Override
    public Future<TransferStatus> submit(TransferWorker.TransferCallable runnable) throws BackgroundException {
        return ConcurrentUtils.constantFuture((Object)runnable.call());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SingleTransferWorker{");
        sb.append("source=").append(this.source);
        sb.append(", destination=").append(this.destination);
        sb.append('}');
        return sb.toString();
    }
}

