/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.MappingMimeTypeService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;

public class TouchWorker
extends Worker<Path> {
    private final Path file;

    public TouchWorker(Path file) {
        this.file = file;
    }

    @Override
    public Path run(Session<?> session) throws BackgroundException {
        Touch feature = session.getFeature(Touch.class);
        if (!feature.isSupported(this.file.getParent())) {
            throw new UnsupportedException();
        }
        return feature.touch(this.file, new TransferStatus().exists(false).length(0L).withMime(new MappingMimeTypeService().getMime(this.file.getName())));
    }

    @Override
    public Path initialize() {
        return this.file;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Uploading {0}", "Status"), this.file.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TouchWorker that = (TouchWorker)o;
        return !(this.file == null ? that.file != null : !this.file.equals(that.file));
    }

    public int hashCode() {
        return this.file != null ? this.file.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TouchWorker{");
        sb.append("file=").append(this.file);
        sb.append('}');
        return sb.toString();
    }
}

