/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.worker.ActionListProgressListener;
import ch.cyberduck.core.worker.BooleanRecursiveCallback;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.List;

public class WriteEncryptionWorker
extends Worker<Boolean> {
    private final List<Path> files;
    private final Encryption.Algorithm algorithm;
    private final Worker.RecursiveCallback<Encryption.Algorithm> callback;
    private final ProgressListener listener;

    public WriteEncryptionWorker(List<Path> files, Encryption.Algorithm algorithm, boolean recursive, ProgressListener listener) {
        this(files, algorithm, new BooleanRecursiveCallback<Encryption.Algorithm>(recursive), listener);
    }

    public WriteEncryptionWorker(List<Path> files, Encryption.Algorithm algorithm, Worker.RecursiveCallback<Encryption.Algorithm> callback, ProgressListener listener) {
        this.files = files;
        this.algorithm = algorithm;
        this.callback = callback;
        this.listener = listener;
    }

    @Override
    public Boolean run(Session<?> session) throws BackgroundException {
        Encryption feature = session.getFeature(Encryption.class);
        for (Path file : this.files) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            this.write(session, feature, file);
        }
        return true;
    }

    protected void write(Session<?> session, Encryption feature, Path file) throws BackgroundException {
        if (this.isCanceled()) {
            throw new ConnectionCanceledException();
        }
        this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Writing metadata of {0}", "Status"), file.getName()));
        feature.setEncryption(file, this.algorithm);
        if (file.isDirectory() && this.callback.recurse(file, this.algorithm)) {
            for (Path child : session.getFeature(ListService.class).list(file, new ActionListProgressListener(this, this.listener))) {
                this.write(session, feature, child);
            }
        }
    }

    @Override
    public Boolean initialize() {
        return false;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Writing metadata of {0}", "Status"), this.toString(this.files));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteEncryptionWorker that = (WriteEncryptionWorker)o;
        return !(this.files != null ? !this.files.equals(that.files) : that.files != null);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteRedundancyWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

