/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.PermissionOverwrite;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.worker.ActionListProgressListener;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WritePermissionWorker
extends Worker<Boolean> {
    private final List<Path> files;
    private final Map<Path, Permission> permissions;
    private final Worker.RecursiveCallback<Permission> callback;
    private final ProgressListener listener;

    public WritePermissionWorker(List<Path> files, Permission permission, Worker.RecursiveCallback<Permission> callback, ProgressListener listener) {
        this.files = files;
        this.permissions = new HashMap<Path, Permission>();
        for (Path f : files) {
            this.permissions.put(f, permission);
        }
        this.callback = callback;
        this.listener = listener;
    }

    public WritePermissionWorker(List<Path> files, PermissionOverwrite overwrite, Worker.RecursiveCallback<Permission> callback, ProgressListener listener) {
        this.files = files;
        this.permissions = new HashMap<Path, Permission>();
        for (Path f : files) {
            this.permissions.put(f, overwrite.resolve(f.attributes().getPermission()));
        }
        this.callback = callback;
        this.listener = listener;
    }

    @Override
    public Boolean run(Session<?> session) throws BackgroundException {
        UnixPermission feature = session.getFeature(UnixPermission.class);
        for (Path file : this.files) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            Permission merged = this.permissions.get(file);
            this.write(session, feature, file, merged);
        }
        return true;
    }

    protected void write(Session<?> session, UnixPermission feature, Path file, Permission permission) throws BackgroundException {
        this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Changing permission of {0} to {1}", "Status"), file.getName(), permission));
        feature.setUnixPermission(file, permission);
        if (file.isDirectory() && this.callback.recurse(file, permission)) {
            for (Path child : session.getFeature(ListService.class).list(file, new ActionListProgressListener(this, this.listener))) {
                this.write(session, feature, child, permission);
            }
        }
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Changing permission of {0} to {1}", "Status"), this.toString(this.files), this.permissions);
    }

    @Override
    public Boolean initialize() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WritePermissionWorker that = (WritePermissionWorker)o;
        return !(this.files != null ? !this.files.equals(that.files) : that.files != null);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WritePermissionWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

