/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.browser;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.date.AbstractUserDateFormatter;
import ch.cyberduck.core.formatter.SizeFormatter;
import ch.cyberduck.core.formatter.SizeFormatterFactory;
import ch.cyberduck.core.io.Checksum;
import org.apache.commons.lang3.StringUtils;

public class PathTooltipService {
    private final SizeFormatter sizeFormatter;
    private final AbstractUserDateFormatter dateFormatter;

    public PathTooltipService() {
        this(SizeFormatterFactory.get(), UserDateFormatterFactory.get());
    }

    public PathTooltipService(SizeFormatter sizeFormatter, AbstractUserDateFormatter dateFormatter) {
        this.sizeFormatter = sizeFormatter;
        this.dateFormatter = dateFormatter;
    }

    public String getTooltip(Path file) {
        Checksum checksum;
        StringBuilder tooltip = new StringBuilder(file.getAbsolute());
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getRegion())) {
            tooltip.append("\n").append(file.attributes().getRegion());
        }
        if (Checksum.NONE != (checksum = file.attributes().getChecksum())) {
            tooltip.append("\n").append(String.format("%s %s", StringUtils.upperCase((String)checksum.algorithm.name()), checksum.hash));
        }
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            tooltip.append("\n").append(file.attributes().getVersionId());
        }
        tooltip.append("\n").append(this.sizeFormatter.format(file.attributes().getSize()));
        tooltip.append("\n").append(this.dateFormatter.getLongFormat(file.attributes().getModificationDate()));
        return tooltip.toString();
    }
}

