/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.browser;

import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.ui.browser.DirectoryFinder;
import org.apache.log4j.Logger;

public class UploadDirectoryFinder
implements DirectoryFinder {
    private static final Logger log = Logger.getLogger(UploadDirectoryFinder.class);
    private final BookmarkCollection collection = BookmarkCollection.defaultCollection();
    private final Preferences preferences = PreferencesFactory.get();

    @Override
    public Local find(Host bookmark) {
        if (null != bookmark.getUploadFolder() && bookmark.getUploadFolder().exists()) {
            return bookmark.getUploadFolder();
        }
        Local directory = LocalFactory.get(this.preferences.getProperty("local.user.home"));
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Suggest default upload folder %s for bookmark %s", directory, bookmark));
        }
        return directory;
    }

    @Override
    public void save(Host bookmark, Local directory) {
        if (!directory.exists()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Save default upload folder %s for bookmark %s", directory, bookmark));
        }
        bookmark.setUploadFolder(directory);
        if (this.collection.contains(bookmark)) {
            this.collection.collectionItemChanged(bookmark);
        }
    }
}

