/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib;

import java.security.SecureRandom;
import org.cryptomator.cryptolib.DaggerCryptoLibComponent;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.KeyFile;
import org.cryptomator.cryptolib.common.SecureRandomModule;

public final class Cryptors {
    public static CryptorProvider version1(SecureRandom seeder) {
        return DaggerCryptoLibComponent.builder().secureRandomModule(new SecureRandomModule(seeder)).build().version1();
    }

    public static long cleartextSize(long ciphertextSize, Cryptor cryptor) {
        long additionalCleartextBytes;
        long cleartextChunkSize = cryptor.fileContentCryptor().cleartextChunkSize();
        long ciphertextChunkSize = cryptor.fileContentCryptor().ciphertextChunkSize();
        long overheadPerChunk = ciphertextChunkSize - cleartextChunkSize;
        long numFullChunks = ciphertextSize / ciphertextChunkSize;
        long additionalCiphertextBytes = ciphertextSize % ciphertextChunkSize;
        if (additionalCiphertextBytes > 0L && additionalCiphertextBytes <= overheadPerChunk) {
            throw new IllegalArgumentException("Method not defined for input value " + ciphertextSize);
        }
        long l = additionalCleartextBytes = additionalCiphertextBytes == 0L ? 0L : additionalCiphertextBytes - overheadPerChunk;
        assert (additionalCleartextBytes >= 0L);
        return cleartextChunkSize * numFullChunks + additionalCleartextBytes;
    }

    public static long ciphertextSize(long cleartextSize, Cryptor cryptor) {
        long additionalCiphertextBytes;
        long cleartextChunkSize = cryptor.fileContentCryptor().cleartextChunkSize();
        long ciphertextChunkSize = cryptor.fileContentCryptor().ciphertextChunkSize();
        long overheadPerChunk = ciphertextChunkSize - cleartextChunkSize;
        long numFullChunks = cleartextSize / cleartextChunkSize;
        long additionalCleartextBytes = cleartextSize % cleartextChunkSize;
        long l = additionalCiphertextBytes = additionalCleartextBytes == 0L ? 0L : additionalCleartextBytes + overheadPerChunk;
        assert (additionalCiphertextBytes >= 0L);
        return ciphertextChunkSize * numFullChunks + additionalCiphertextBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] changePassphrase(CryptorProvider cryptoProvider, byte[] masterkey, CharSequence oldPassphrase, CharSequence newPassphrase) throws InvalidPassphraseException {
        KeyFile keyFile = KeyFile.parse(masterkey);
        Cryptor cryptor = cryptoProvider.createFromKeyFile(keyFile, oldPassphrase, keyFile.getVersion());
        try {
            byte[] byArray = cryptor.writeKeysToMasterkeyFile(newPassphrase, keyFile.getVersion()).serialize();
            return byArray;
        }
        finally {
            cryptor.destroy();
        }
    }
}

